/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.X509.DisplayText;
import org.eclipse.higgins.keystore.common.X509.NoticeReference;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class UserNotice {
    NoticeReference noticeRef;
    DisplayText explicitText;

    public UserNotice(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty()) {
            for (int i = 0; i < node.getCollection().size(); ++i) {
                Asn1Node subNode = (Asn1Node)node.getCollection().get(i);
                if (subNode.getTag() == 48) {
                    this.explicitText = new DisplayText(subNode);
                    continue;
                }
                this.noticeRef = new NoticeReference(subNode);
            }
        }
    }

    public String toString() {
        StringBuffer stringbuilder = new StringBuffer("");
        if (this.noticeRef != null || this.explicitText != null) {
            stringbuilder.append("UserNotice: [\n");
            if (this.noticeRef != null) {
                stringbuilder.append("noticeRef: ");
                stringbuilder.append(this.noticeRef.toString());
            }
            if (this.explicitText != null) {
                stringbuilder.append("\n   explicitText: ");
                stringbuilder.append(this.explicitText.toString());
            }
            stringbuilder.append("]\n");
        }
        return stringbuilder.toString();
    }
}

