/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateParsingException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class X501Name {
    private Hashtable value = null;
    private static Hashtable Keywords = new Hashtable();

    public X501Name(Asn1Node node) {
        try {
            this.value = new Hashtable();
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAttributeValue(ObjectIdentifier oid) {
        return (String)this.value.get(oid);
    }

    public String getAttributeValueByName(String name) {
        try {
            String oid = (String)Keywords.get(name.toUpperCase());
            if (oid != null) {
                return (String)this.value.get(new ObjectIdentifier(oid));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty()) {
            Iterator iter = node.getCollection().iterator();
            while (iter.hasNext()) {
                this.parseRND((Asn1Node)iter.next());
            }
        }
    }

    private void parseRND(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty()) {
            Iterator iter = node.getCollection().iterator();
            while (iter.hasNext()) {
                this.parseAttributeTypeAndValue((Asn1Node)iter.next());
            }
        }
    }

    private void parseAttributeTypeAndValue(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
            ObjectIdentifier key = new ObjectIdentifier((Asn1Node)node.getCollection().get(0));
            String valueKey = null;
            try {
                valueKey = ((Asn1Node)node.getCollection().get(1)).getValueAsString();
            }
            catch (UnsupportedEncodingException e) {
                throw (CertificateParsingException)new CertificateParsingException(e.toString()).initCause(e);
            }
            if (valueKey != null) {
                this.value.put(key, valueKey);
            }
        }
    }

    static {
        Keywords.put("CN", "2.5.4.3");
        Keywords.put("C", "2.5.4.6");
        Keywords.put("L", "2.5.4.7");
        Keywords.put("ST", "2.5.4.8");
        Keywords.put("O", "2.5.4.10");
        Keywords.put("OU", "2.5.4.11");
    }
}

