/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.common.X509.AuthorityInformationAccessExtension;
import org.eclipse.higgins.keystore.common.X509.CertificatePoliciesExtension;
import org.eclipse.higgins.keystore.common.X509.TBSCertificate;

public class X509HigginsCertificate
extends X509Certificate {
    private static final long serialVersionUID = 2282425799629719567L;
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$keystore$common$X509$X509HigginsCertificate == null ? (class$org$eclipse$higgins$keystore$common$X509$X509HigginsCertificate = X509HigginsCertificate.class$("org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate")) : class$org$eclipse$higgins$keystore$common$X509$X509HigginsCertificate));
    private X509Certificate instance = null;
    private CertificatePoliciesExtension certificatePolicies;
    private AuthorityInformationAccessExtension authorityInformationAccess;
    private String fingerprintSHA1;
    private TBSCertificate tBSCertificateObject = null;
    static /* synthetic */ Class class$org$eclipse$higgins$keystore$common$X509$X509HigginsCertificate;

    public String getFingerprintSHA1() {
        return this.fingerprintSHA1;
    }

    public AuthorityInformationAccessExtension getAuthorityInformationAccess() {
        return this.authorityInformationAccess;
    }

    public CertificatePoliciesExtension getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public X509HigginsCertificate(X509Certificate certificate) {
        this.instance = certificate;
        this.initialization();
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.instance.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.instance.checkValidity(date);
    }

    public int getBasicConstraints() {
        return this.instance.getBasicConstraints();
    }

    public Principal getIssuerDN() {
        return this.instance.getIssuerDN();
    }

    public boolean[] getIssuerUniqueID() {
        return this.instance.getIssuerUniqueID();
    }

    public boolean[] getKeyUsage() {
        return this.instance.getKeyUsage();
    }

    public Date getNotAfter() {
        return this.instance.getNotAfter();
    }

    public Date getNotBefore() {
        return this.instance.getNotBefore();
    }

    public BigInteger getSerialNumber() {
        return this.instance.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.instance.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.instance.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.instance.getSigAlgParams();
    }

    public byte[] getSignature() {
        return this.instance.getSignature();
    }

    public Principal getSubjectDN() {
        return this.instance.getSubjectDN();
    }

    public boolean[] getSubjectUniqueID() {
        return this.instance.getSubjectUniqueID();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.instance.getTBSCertificate();
    }

    public int getVersion() {
        return this.instance.getVersion();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.instance.getEncoded();
    }

    public PublicKey getPublicKey() {
        return this.instance.getPublicKey();
    }

    public String toString() {
        return this.instance.toString();
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.instance.verify(key);
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.instance.verify(key, sigProvider);
    }

    public Set getCriticalExtensionOIDs() {
        return this.instance.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.instance.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.instance.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.instance.hasUnsupportedCriticalExtension();
    }

    public TBSCertificate getTBSCertificateObject() {
        return this.tBSCertificateObject;
    }

    private void initialization() {
        this.calculateFingerprintSHA1();
        try {
            this.tBSCertificateObject = new TBSCertificate(this.instance.getTBSCertificate());
        }
        catch (CertificateEncodingException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        if (this.instance == null) {
            return;
        }
        byte[] certificatePoliciesByteArray = this.instance.getExtensionValue("2.5.29.32");
        Set<String> criticalExtention = this.instance.getCriticalExtensionOIDs();
        if (criticalExtention == null) {
            return;
        }
        boolean critical = false;
        if (criticalExtention == null) {
            critical = criticalExtention.contains("2.5.29.32");
        }
        if (certificatePoliciesByteArray != null && certificatePoliciesByteArray.length > 0) {
            this.certificatePolicies = new CertificatePoliciesExtension(certificatePoliciesByteArray, critical);
        }
        byte[] authorityInformationAccessByteArray = this.instance.getExtensionValue("1.3.6.1.5.5.7.1.1");
        critical = false;
        if (criticalExtention == null) {
            critical = criticalExtention.contains("1.3.6.1.5.5.7.1.1");
        }
        if (authorityInformationAccessByteArray != null && authorityInformationAccessByteArray.length > 0) {
            this.authorityInformationAccess = new AuthorityInformationAccessExtension(authorityInformationAccessByteArray, critical);
        }
    }

    private void calculateFingerprintSHA1() {
        if (this.instance == null) {
            return;
        }
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        if (sha1 == null) {
            return;
        }
        sha1.reset();
        byte[] result = null;
        try {
            result = sha1.digest(this.instance.getEncoded());
        }
        catch (CertificateEncodingException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        if (result == null) {
            return;
        }
        StringBuffer builder = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            String strValue = Integer.toHexString(0xFF & result[i]).toLowerCase();
            if (strValue.length() == 1) {
                builder.append("0");
            }
            builder.append(strValue);
            if (i == result.length - 1) continue;
            builder.append(" ");
        }
        this.fingerprintSHA1 = builder.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

