/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.common.X509.PolicyInformation;
import org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate;

public abstract class KeyStoreService
implements IKeyStoreService {
    private Log log;
    private static Hashtable signsTable = new Hashtable();
    static /* synthetic */ Class class$0;

    static {
        signsTable.put("66 31 bf 9e f7 4f 9e b6 c9 d5 a6 0c ba 6a be d1 f7 bd ef 7b", "1.3.6.1.4.1.6449.1.2.1.5.1");
        signsTable.put("5f 43 e5 b1 bf f8 78 8c ac 1c c7 ca 4a 9a c6 22 2b cc 34 c6", "1.3.6.1.4.1.6334.1.100.1");
        signsTable.put("5f b7 ee 06 33 e2 59 db ad 0c 4c 9a e6 d3 8f 1a 61 c7 dc 25", "2.16.840.1.114412.2.1");
        signsTable.put("f0 bb 01 d1 d8 31 98 51 6a 4f f1 6d 8a b5 ef ab 74 c7 cc a3", "2.16.528.1.1001.1.1.1.12.6.1.1.1");
        signsTable.put("b3 1e b1 b7 40 e3 6c 84 02 da dc 37 d4 4d f5 d4 67 49 52 f9", "2.16.840.1.114028.10.1.2");
        signsTable.put("32 3c 11 8e 1b f7 b8 b6 52 54 e2 e2 10 0d d6 02 90 37 f0 96", "1.3.6.1.4.1.14370.1.6");
        signsTable.put("75 e0 ab b6 13 85 12 27 1c 04 f8 5f dd de 38 e4 b7 24 2e fe", "1.3.6.1.4.1.4146.1.1");
        signsTable.put("27 96 ba e6 3f 18 01 e2 77 26 1b a0 d7 77 70 02 8f 20 ee e4", "2.16.840.1.114413.1.7.23.3");
        signsTable.put("74 f8 a3 c3 ef e7 b3 90 06 4b 83 90 3c 21 64 60 20 e5 df ce", "1.3.6.1.4.1.782.1.2.1.8.1");
        signsTable.put("ca 3a fb cf 12 40 36 4b 44 b2 16 20 88 80 48 39 19 93 7c f7", "1.3.6.1.4.1.8024.0.2.100.1.2");
        signsTable.put("ad 7e 1c 28 b0 64 ef 8f 60 03 40 20 14 c3 d0 e3 37 0e b5 8a", "2.16.840.1.114414.1.7.23.3");
        signsTable.put("87 82 c6 c3 04 35 3b cf d2 96 92 d2 59 3e 7d 44 d9 34 ff 11", "2.16.840.1.114404.1.1.2.4.1");
        signsTable.put("91 c6 d6 ee 3e 8a c8 63 84 e5 48 c2 99 29 5c 75 6c 81 7b 81", "2.16.840.1.113733.1.7.48.1");
        signsTable.put("4e b6 d5 78 49 9b 1c cf 5f 58 1e ad 56 be 3d 9b 67 44 a5 e5", "2.16.840.1.113733.1.7.23.6");
    }

    public KeyStoreService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.keystore.common.KeyStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public X509Certificate[] getValidateCertificateChain(CallbackHandler handler, X509Certificate[] certPath, URI uri, CertStore certStore) throws CertificateException, CertStoreException {
        try {
            X509Certificate[] chain = this.getParent(certPath, certStore);
            if (this.validateCertificateChain(handler, chain, uri, certStore)) {
                return chain;
            }
        }
        catch (GeneralSecurityException e) {
            this.log.error((Object)e, (Throwable)e);
            CertificateException exc = new CertificateException(e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            CertificateException exc = new CertificateException(e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
        return null;
    }

    protected X509Certificate[] getNormalizedCertificateChain(X509Certificate[] certPath, CertStore certStore) throws CertificateException, CertStoreException {
        try {
            X509Certificate[] chain = this.getParent(certPath, certStore);
            return chain;
        }
        catch (GeneralSecurityException e) {
            this.log.error((Object)e, (Throwable)e);
            CertificateException exc = new CertificateException(e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            CertificateException exc = new CertificateException(e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
    }

    public boolean extendendValidationCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri, CertStore certStore) {
        boolean result = false;
        result = this.validateCertificateChain(handler, certChain, uri, certStore);
        if (result) {
            result = this.extendendValidationCertificate(certChain);
        }
        return result;
    }

    protected boolean extendendValidationCertificate(X509Certificate[] certChain) {
        boolean result = false;
        X509Certificate rootCert = certChain[certChain.length - 1];
        X509HigginsCertificate rootHigginsCert = null;
        rootHigginsCert = rootCert instanceof X509HigginsCertificate ? (X509HigginsCertificate)rootCert : new X509HigginsCertificate(rootCert);
        String policyOID = (String)signsTable.get(rootHigginsCert.getFingerprintSHA1());
        if (policyOID == null) {
            return false;
        }
        result = this.policyValidationCertificate(certChain[0], policyOID, false);
        if (!result) {
            return false;
        }
        int i = 1;
        while (i < certChain.length - 1) {
            result = this.policyValidationCertificate(certChain[i], policyOID, true);
            if (!result) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean uriValidationCertificate(X509Certificate cert, URI uri) throws URISyntaxException {
        X509HigginsCertificate higginsCert = null;
        higginsCert = cert instanceof X509HigginsCertificate ? (X509HigginsCertificate)cert : new X509HigginsCertificate(cert);
        String certHost = higginsCert.getTBSCertificateObject().getSubject().getAttributeValueByName("CN").toLowerCase();
        String host = uri.getHost();
        host = host != null ? host.toLowerCase() : uri.toString();
        return certHost.startsWith("*.") ? host.endsWith(certHost = certHost.substring(2)) : host.equals(certHost);
    }

    protected boolean policyValidationCertificate(X509Certificate cert, String policyOID, boolean isAnyPolicy) {
        X509HigginsCertificate higginsCert = null;
        higginsCert = cert instanceof X509HigginsCertificate ? (X509HigginsCertificate)cert : new X509HigginsCertificate(cert);
        if (higginsCert.getCertificatePolicies() == null) {
            return false;
        }
        Iterator iter = higginsCert.getCertificatePolicies().getCertificatePolicies().iterator();
        while (iter.hasNext()) {
            PolicyInformation policy = (PolicyInformation)iter.next();
            if (policy.getPolicyIdentifier().equals(policyOID)) {
                return true;
            }
            if (!isAnyPolicy || !policy.getPolicyIdentifier().equals("2.5.29.32.0")) continue;
            return true;
        }
        return false;
    }

    public boolean validateCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri, CertStore certStore) {
        block7: {
            block6: {
                if (certChain != null) break block6;
                return false;
            }
            if (uri == null || this.uriValidationCertificate(certChain[0], uri)) break block7;
            return false;
        }
        try {
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            Collection<? extends Certificate> colSert = certStore.getCertificates(null);
            Iterator<? extends Certificate> iter = colSert.iterator();
            while (iter.hasNext()) {
                trustAnchors.add(new TrustAnchor((X509Certificate)iter.next(), null));
            }
            PKIXParameters params = new PKIXParameters(trustAnchors);
            params.setRevocationEnabled(false);
            List<X509Certificate> ll = Arrays.asList(certChain);
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            CertPath certPath = certFact.generateCertPath(ll);
            CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            CertPathValidatorResult result = certPathValidator.validate(certPath, params);
            return result != null;
        }
        catch (CertPathValidatorException e) {
            this.log.debug((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    protected X509Certificate[] getParent(X509Certificate[] certificates, CertStore certStore) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, CertStoreException {
        ArrayList<X509Certificate> path = new ArrayList<X509Certificate>();
        List parentPath = null;
        X509Certificate cert = this.findLeafFromCertificates(certificates);
        List<X509Certificate> inputList = Arrays.asList(certificates);
        CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(inputList);
        CertStore tempStore = CertStore.getInstance("Collection", collCSP);
        X509CertSelector selector = new X509CertSelector();
        path.add(cert);
        while (!this.isRootCertificate(cert)) {
            parentPath = this.getParent(cert, certStore, path);
            if (parentPath != null) break;
            selector.setSubject(cert.getIssuerX500Principal().getName());
            Collection<? extends Certificate> collCertificates = tempStore.getCertificates(selector);
            if (collCertificates.isEmpty()) break;
            cert = (X509Certificate)collCertificates.iterator().next();
            path.add(cert);
        }
        if (parentPath != null) {
            X509Certificate[] chain = new X509Certificate[parentPath.size()];
            parentPath.toArray(chain);
            return chain;
        }
        return null;
    }

    protected List getParent(X509Certificate certificate, CertStore certStore, List path) {
        if (certificate != null) {
            X509Certificate cert = this.extendExternalPath(certificate);
            if (cert == null) {
                cert = this.extendLocalPath(certificate, certStore);
            }
            if (cert != null) {
                path.add(cert);
                if (!this.isRootCertificate(cert)) {
                    return this.getParent(cert, certStore, path);
                }
                return path;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected X509Certificate extendExternalPath(X509Certificate certificate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 242->245)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected X509Certificate extendLocalPath(X509Certificate certificate, CertStore certStore) {
        try {
            Collection<? extends Certificate> list;
            X509Certificate parentCert = null;
            X509CertSelector selector = new X509CertSelector();
            selector.setSubject(certificate.getIssuerX500Principal().getName("CANONICAL"));
            if (certStore != null && !(list = certStore.getCertificates(selector)).isEmpty()) {
                parentCert = (X509Certificate)list.toArray()[0];
                return new X509HigginsCertificate(parentCert);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    protected boolean isRootCertificate(X509Certificate cert) {
        X500Principal issuer_dn = null;
        X500Principal subject_dn = null;
        issuer_dn = cert.getIssuerX500Principal();
        subject_dn = cert.getSubjectX500Principal();
        return issuer_dn.equals(subject_dn);
    }

    public X509Certificate findLeafFromCertificates(X509Certificate[] listCerts) {
        if (listCerts.length == 0) {
            return null;
        }
        if (1 == listCerts.length) {
            return listCerts[0];
        }
        HashMap<String, String> issuerMap = new HashMap<String, String>();
        ArrayList<String> subjectList = new ArrayList<String>();
        int iCert = 0;
        while (iCert < listCerts.length) {
            X509Certificate x509Certificate = listCerts[iCert];
            String strSubject = x509Certificate.getSubjectX500Principal().getName();
            String strIssuer = x509Certificate.getIssuerX500Principal().getName();
            issuerMap.put(strIssuer, strSubject);
            subjectList.add(strSubject);
            ++iCert;
        }
        iCert = 0;
        while (iCert < subjectList.size()) {
            String strSubject = (String)subjectList.get(iCert);
            if (issuerMap.get(strSubject) == null) {
                return listCerts[iCert];
            }
            ++iCert;
        }
        return null;
    }

    public static CertStore joinCertStore(CertStore certStore1, CertStore certStore2) {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        if (certStore1 == null) {
            return certStore2;
        }
        if (certStore2 == null) {
            return certStore1;
        }
        try {
            certificates.addAll(certStore1.getCertificates(null));
        }
        catch (CertStoreException e1) {
            e1.printStackTrace();
        }
        try {
            certificates.addAll(certStore2.getCertificates(null));
        }
        catch (CertStoreException e1) {
            e1.printStackTrace();
        }
        CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(certificates);
        try {
            return CertStore.getInstance("Collection", collCSP);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }
}

