/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *    AuthorityInfoAccessSyntax  ::= SEQUENCE SIZE (1..MAX) OF AccessDescription
 * </pre>
 * 
 * @author Artem Verkhovets
 * 
 */
public class AuthorityInformationAccessExtension extends Extension {

	private List accessDescriptions;

	public List getAccessDescriptions() {
		return accessDescriptions;
	}

	public void setAccessDescriptions(List accessDescription) {
		this.accessDescriptions = accessDescription;
	}

	public AuthorityInformationAccessExtension(byte[] extensionValue, boolean critical) {
		super();
		accessDescriptions = new ArrayList();
		this.critical = critical;
		this.extensionValue = extensionValue;
		try {
			this.extensionId = new ObjectIdentifier(ObjectIdentifier.id_pe_authorityInfoAccess);
			Asn1Node node = Asn1Node.getInstance(extensionValue);
			if (node.getTag() == Asn1Node.tag_OctetString)
				node = Asn1Node.getInstance(node.getValue());

			if (node.getTag() == Asn1Node.tag_Sequence || node.getTag() == Asn1Node.tag_SequenceOf)
				parse(node);
		} catch (Exception exc) {
		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty()) {
			for (Iterator iter = node.getCollection().iterator(); iter.hasNext();) {
				accessDescriptions.add(new AccessDescription((Asn1Node) iter.next()));
			}
		}
	}

	public String toString() {
		if (accessDescriptions == null)
			return "";
		StringBuffer stringbuilder = new StringBuffer(super.toString());
		stringbuilder.append("AuthorityInfoAccess [\n");
		AccessDescription description;
		for (Iterator iterator = accessDescriptions.iterator(); iterator.hasNext(); stringbuilder.append(description.toString()))
			description = (AccessDescription) iterator.next();

		stringbuilder.append("]\n");
		return stringbuilder.toString();
	}
}
