package org.eclipse.higgins.keystore.common.impl;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

import javax.security.auth.callback.CallbackHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.common.KeyStoreService;
import org.eclipse.higgins.registry.IConfiguration;

public final class KeyStoreServiceImp extends KeyStoreService {

	private CertStore defaultCertStore = null;

	private String id = "org.eclipse.higgins.security.provider.default";

	private Log log = LogFactory.getLog(KeyStoreServiceImp.class);

	/**
	 * 
	 */
	public KeyStoreServiceImp() {
		super();
		initialize();
	}

	public CertStore addToCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore addToCertStore(CallbackHandler handler,X509Certificate[] certificates) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore deleteFromCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore deleteFromCertStore(CallbackHandler handler,X509Certificate[] certificates) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore getCertStore(CallbackHandler handler) throws CertificateException, CertStoreException {
		return getDefaultCertStore(handler);
	}

	public CertStore getDefaultCertStore(CallbackHandler handler) {
		return defaultCertStore;
	}

	public IConfiguration getConfiguration() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getID() {
		return id;
	}

	public void setID(String id) throws Exception {
		this.id = id;
	}

	public X509Certificate[] getValidateCertificateChain(CallbackHandler handler,X509Certificate[] certPath, URI uri) throws CertificateException, CertStoreException {

		return getValidateCertificateChain(handler,certPath, uri,null);
	}

	public X509Certificate[] getValidateCertificateChain(CallbackHandler handler,X509Certificate[] certPath, URI uri, CertStore certStore) throws CertificateException, CertStoreException {
		CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
		return super.getValidateCertificateChain(handler,certPath, uri, tempCertStore);
	}
	
	public X509Certificate [] getNormalizedCertificateChain(CallbackHandler handler,X509Certificate [] certPath, CertStore certStore) throws CertificateException, CertStoreException
	{
		CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
		return super.getNormalizedCertificateChain(certPath,tempCertStore);
	}

	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate[] certChain,URI uri) {
		return extendendValidationCertificateChain(handler,certChain, uri, null);
	}
	
	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate[] certChain,URI uri, CertStore certStore) {
		try {
			CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
			return super.extendendValidationCertificateChain(handler,certChain, uri, tempCertStore);
		} catch (Exception e) {
			log.error(e, e);
		}
		return false;
	}

	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate[] certChain, URI uri) {
		return validateCertificateChain(handler,certChain, uri, null);
	}

	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate[] certChain, URI uri, CertStore certStore) {

		try {
			CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
			return super.validateCertificateChain(handler,certChain, uri, tempCertStore);
		} catch (Exception e) {
			log.error(e, e);
		}
		return false;
	}

	private void initialize() {
		KeyStore keystore = null;
		String password = "changeit";
		Collection collCertificates = new ArrayList();
		try {
			String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
			FileInputStream is = new FileInputStream(filename);
			keystore = KeyStore.getInstance(KeyStore.getDefaultType());
			keystore.load(is, password.toCharArray());

			Enumeration enumCertificates = keystore.aliases();
			while (enumCertificates.hasMoreElements()) {
				String strAlias = (String) enumCertificates.nextElement();
				Certificate cert = keystore.getCertificate(strAlias);
				collCertificates.add(cert);
			}
		} catch (Exception e) {
//			 TODO Auto-generated catch block
			e.printStackTrace();
		}

		try {
			String filename = System.getProperty("javax.net.ssl.trustStore");
			password = (System.getProperty("javax.net.ssl.trustStorePassword") != null) ? System.getProperty("javax.net.ssl.trustStorePassword") : password;

			FileInputStream is = new FileInputStream(filename);
			keystore = KeyStore.getInstance(KeyStore.getDefaultType());
			keystore.load(is, password.toCharArray());

			Enumeration enumCertificates = keystore.aliases();
			while (enumCertificates.hasMoreElements()) {
				String strAlias = (String) enumCertificates.nextElement();
				Certificate cert = keystore.getCertificate(strAlias);
				collCertificates.add(cert);
			}
		} catch (Exception e) {
//			 TODO Auto-generated catch block
			e.printStackTrace();
		}

		CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(collCertificates);
		try {
			defaultCertStore = CertStore.getInstance("Collection", collCSP);
		} catch (InvalidAlgorithmParameterException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
