/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *  AccessDescription  ::=  SEQUENCE {
 *         accessMethod          OBJECT IDENTIFIER,
 *         accessLocation        GeneralName  }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 * 
 */

public class AccessDescription {
	private ObjectIdentifier accessMethod;

	private GeneralName accessLocation;

	public GeneralName getAccessLocation() {
		return accessLocation;
	}

	public void setAccessLocation(GeneralName accessLocation) {
		this.accessLocation = accessLocation;
	}

	public ObjectIdentifier getAccessMethod() {
		return accessMethod;
	}

	public void setAccessMethod(ObjectIdentifier accessMethod) {
		this.accessMethod = accessMethod;
	}

	public AccessDescription(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty() && node.getCollection().size() >= 1) {
			Asn1Node oidNode = (Asn1Node) node.getCollection().get(0);
			this.accessMethod = new ObjectIdentifier(oidNode);
			if (node.getCollection().size() > 1) {
				Asn1Node locationNode = (Asn1Node) node.getCollection().get(1);
				this.accessLocation = new GeneralName(locationNode);
			}
		}
	}

	public String toString() {
		return (new StringBuffer()).append("accessMethod: ").append(accessMethod.toString()).append("\n   accessLocation: ").append(accessLocation.toString()).toString();
	}
}
