/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *  GeneralName ::= CHOICE {
 *      otherName                       [0]     OtherName,
 *      rfc822Name                      [1]     IA5String,
 *      dNSName                         [2]     IA5String,
 *      x400Address                     [3]     ORAddress,
 *      directoryName                   [4]     Name,
 *      ediPartyName                    [5]     EDIPartyName,
 *      uniformResourceIdentifier       [6]     IA5String,
 *      iPAddress                       [7]     OCTET STRING,
 *      registeredID                    [8]     OBJECT IDENTIFIER }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 */
public class GeneralName {

	private Object value = null;

	public GeneralName(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (node != null) {
			value = null;
			short word0 = (byte) (node.getTag() & 0x1f);
			switch (word0) {
			case 0:
				break;
			case 1:
				break;
			case 2:
				break;
			case 3:
				break;
			case 4:
				break;
			case 5:
				break;
			case 6:
				if (node.isContextSpecific() && !node.isConstructed()) {
					value = new URIName(node);
				} else {
					throw new CertificateParsingException("Invalid encoding of URI");
				}
				break;
			case 7:
				break;
			case 8:
				break;
			default:
				throw new CertificateParsingException((new StringBuffer()).append("Unrecognized GeneralName tag, (").append(word0).append(")").toString());
			}
		}
	}

	public String toString() {
		return value.toString();
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}
}
