/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.keystore.common.X509.DisplayText;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class NoticeReference {
    DisplayText organization;
    List noticeNumbers = new ArrayList();

    public NoticeReference(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
            Asn1Node organizationNode = (Asn1Node)node.getCollection().get(0);
            this.organization = new DisplayText(organizationNode);
            Asn1Node noticeNumbersNode = (Asn1Node)node.getCollection().get(1);
            if (!noticeNumbersNode.getCollection().isEmpty()) {
                Iterator iter = noticeNumbersNode.getCollection().iterator();
                while (iter.hasNext()) {
                    Asn1Node numberNode = (Asn1Node)iter.next();
                    this.noticeNumbers.add(new Integer(numberNode.getInteger()));
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringbuilder = new StringBuffer();
        stringbuilder.append("NoticeReference: [\n");
        if (this.organization != null) {
            stringbuilder.append("organization: ");
            stringbuilder.append(this.organization.toString());
        }
        if (this.noticeNumbers != null) {
            stringbuilder.append("\n   noticeNumbers: ");
            stringbuilder.append(this.noticeNumbers.toString());
        }
        stringbuilder.append("]\n");
        return stringbuilder.toString();
    }
}

