/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.utils;

import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate;
import org.eclipse.higgins.keystore.common.entity.X509CertificateEntity;

public class ConvertHelper {
    public static X509CertificateEntity convertCertChainToEntity(X509Certificate[] certificatePath) throws CertStoreException {
        return ConvertHelper.convertCertChainToEntity(certificatePath, 0);
    }

    private static X509CertificateEntity convertCertChainToEntity(X509Certificate[] certificatePath, int i) throws CertStoreException {
        if (certificatePath != null && certificatePath.length > i) {
            try {
                X509HigginsCertificate cert = null;
                cert = certificatePath[i] instanceof X509HigginsCertificate ? (X509HigginsCertificate)certificatePath[i] : new X509HigginsCertificate(certificatePath[i]);
                X509CertificateEntity entity = new X509CertificateEntity();
                entity.setEncodedCertificate(cert.getEncoded());
                entity.setId(cert.getFingerprintSHA1());
                entity.setSignedBy(ConvertHelper.convertCertChainToEntity(certificatePath, i + 1));
                return entity;
            }
            catch (Exception e) {
                throw new CertStoreException(e);
            }
        }
        return null;
    }

    public static X509HigginsCertificate getX509HigginsCertificate(X509Certificate certificate) {
        if (certificate instanceof X509HigginsCertificate) {
            return (X509HigginsCertificate)certificate;
        }
        return new X509HigginsCertificate(certificate);
    }
}

