/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 * DisplayText ::= CHOICE {
 *      ia5String        IA5String      (SIZE (1..200)),
 *      visibleString    VisibleString  (SIZE (1..200)),
 *      bmpString        BMPString      (SIZE (1..200)),
 *      utf8String       UTF8String     (SIZE (1..200)) }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 * 
 */

public class DisplayText {

	String text = null;

	public DisplayText(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		try {
			text = node.getValueAsString();
		} catch (UnsupportedEncodingException e) {
			throw (CertificateParsingException) (new CertificateParsingException(e.toString())).initCause(e);
		}
	}

	public String getText() {
		return text;
	}

	public void setText(Object text) {
		this.text = text.toString();
	}

	public String toString() {
		return text.toString();
	}
}
