/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.util.Arrays;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *    Extension  ::=  SEQUENCE  {
 *      extnID      OBJECT IDENTIFIER,
 *      critical    BOOLEAN DEFAULT FALSE,
 *      extnValue   OCTET STRING  }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 * 
 */
public class Extension {
	protected ObjectIdentifier extensionId;

	protected boolean critical;

	protected byte extensionValue[];

	public Extension() {
		extensionId = null;
		critical = false;
		extensionValue = null;
	}

	public Extension(byte[] extensionValue, boolean critical) {
		extensionId = null;
		this.extensionValue = extensionValue;
		this.critical = critical;
	}

	public boolean isCritical() {
		return critical;
	}

	public ObjectIdentifier getExtensionId() {
		return extensionId;
	}

	public byte[] getExtensionValue() {
		return extensionValue;
	}

	public String toString() {
		String s = (new StringBuffer()).append("ObjectId: ").append(extensionId.toString()).toString();
		if (critical)
			s = (new StringBuffer()).append(s).append(" Criticality=true\n").toString();
		else
			s = (new StringBuffer()).append(s).append(" Criticality=false\n").toString();
		return s;
	}

	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + (critical ? 1231 : 1237);
		result = PRIME * result + ((extensionId == null) ? 0 : extensionId.hashCode());
		result = PRIME * result + Extension.hashCode(extensionValue);
		return result;
	}

	private static int hashCode(byte[] array) {
		if (array == null)
			return 0;
		int result = 1;
		for (int index = 0; index < array.length; index++) {
		}
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Extension other = (Extension) obj;
		if (critical != other.critical)
			return false;
		if (extensionId == null) {
			if (other.extensionId != null)
				return false;
		} else if (!extensionId.equals(other.extensionId))
			return false;
		if (!Arrays.equals(extensionValue, other.extensionValue))
			return false;
		return true;
	}
}
