/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 * NoticeReference ::= SEQUENCE {
 *      organization     DisplayText,
 *      noticeNumbers    SEQUENCE OF INTEGER }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 * 
 */
public class NoticeReference {

	DisplayText organization;

	List noticeNumbers;

	public NoticeReference(Asn1Node node) {
		noticeNumbers = new ArrayList();
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
			Asn1Node organizationNode = (Asn1Node) node.getCollection().get(0);
			this.organization = new DisplayText(organizationNode);

			Asn1Node noticeNumbersNode = (Asn1Node) node.getCollection().get(1);
			if (!noticeNumbersNode.getCollection().isEmpty()) {
				for (Iterator iter = noticeNumbersNode.getCollection().iterator(); iter.hasNext();) {
					Asn1Node numberNode = (Asn1Node) iter.next();

					this.noticeNumbers.add(new Integer(numberNode.getInteger()));
				}
			}
		}
	}

	public String toString() {
		StringBuffer stringbuilder = new StringBuffer();
		stringbuilder.append("NoticeReference: [\n");
		if (organization != null) {
			stringbuilder.append("organization: ");
			stringbuilder.append(organization.toString());
		}
		if (noticeNumbers != null) {
			stringbuilder.append("\n   noticeNumbers: ");
			stringbuilder.append(noticeNumbers.toString());
		}
		stringbuilder.append("]\n");
		return stringbuilder.toString();
	}
}
