/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.higgins.keystore.common.X509.Extension;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.X509.PolicyInformation;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class CertificatePoliciesExtension
extends Extension {
    private Collection certificatePolicies = new ArrayList();

    public CertificatePoliciesExtension(byte[] extensionValue, boolean critical) {
        this.critical = critical;
        this.extensionValue = extensionValue;
        try {
            this.extensionId = new ObjectIdentifier("2.5.29.32");
            Asn1Node node = Asn1Node.getInstance(extensionValue);
            if (node.getTag() == 4) {
                node = Asn1Node.getInstance(node.getValue());
            }
            if (node.getTag() == 48 || node.getTag() == 48) {
                this.parse(node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public void setCertificatePolicies(Collection certificatePolicies) {
        this.certificatePolicies = certificatePolicies;
    }

    private void parse(Asn1Node node) {
        if (!node.getCollection().isEmpty()) {
            Iterator iter = node.getCollection().iterator();
            while (iter.hasNext()) {
                this.certificatePolicies.add(new PolicyInformation((Asn1Node)iter.next()));
            }
        }
    }

    public String toString() {
        if (this.certificatePolicies == null) {
            return "";
        }
        StringBuffer stringbuilder = new StringBuffer(super.toString());
        stringbuilder.append("CertificatePolicies [\n");
        Iterator iterator = this.certificatePolicies.iterator();
        while (iterator.hasNext()) {
            PolicyInformation policyinformation = (PolicyInformation)iterator.next();
            stringbuilder.append(policyinformation.toString());
        }
        stringbuilder.append("]\n");
        return stringbuilder.toString();
    }
}

