/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.impl;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.common.KeyStoreService;
import org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate;
import org.eclipse.higgins.keystore.common.entity.X509CertificateEntity;
import org.eclipse.higgins.keystore.common.utils.ConvertHelper;
import org.eclipse.higgins.registry.IConfiguration;

public final class KeyStoreServiceImp
extends KeyStoreService {
    private static final HashMap certMap = new HashMap();
    private CertStore defaultTrustCertStore = null;
    private String id = "org.eclipse.higgins.keystore.provider.default";
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$keystore$common$impl$KeyStoreServiceImp == null ? (class$org$eclipse$higgins$keystore$common$impl$KeyStoreServiceImp = KeyStoreServiceImp.class$("org.eclipse.higgins.keystore.common.impl.KeyStoreServiceImp")) : class$org$eclipse$higgins$keystore$common$impl$KeyStoreServiceImp));
    static /* synthetic */ Class class$org$eclipse$higgins$keystore$common$impl$KeyStoreServiceImp;

    public KeyStoreServiceImp() {
        this.initialize();
    }

    public CertStore addToCertStore(CallbackHandler handler, CertStore certStore) throws CertificateException, CertStoreException {
        return null;
    }

    public CertStore addToCertStore(CallbackHandler handler, X509Certificate[] certificates) throws CertificateException, CertStoreException {
        return null;
    }

    public CertStore deleteFromCertStore(CallbackHandler handler, CertStore certStore) throws CertificateException, CertStoreException {
        return null;
    }

    public CertStore deleteFromCertStore(CallbackHandler handler, X509Certificate[] certificates) throws CertificateException, CertStoreException {
        return null;
    }

    public CertStore getCertStore(CallbackHandler handler) throws CertificateException, CertStoreException {
        return this.getDefaultTrustCertStore(handler);
    }

    public CertStore getDefaultTrustCertStore(CallbackHandler handler) {
        return this.defaultTrustCertStore;
    }

    public IConfiguration getConfiguration() {
        return null;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) throws Exception {
        this.id = id;
    }

    public X509Certificate[] getValidateCertificateChain(CallbackHandler handler, X509Certificate[] certPath, URI uri) throws CertificateException, CertStoreException {
        return this.getValidateCertificateChain(handler, certPath, uri, null);
    }

    public X509Certificate[] getValidateCertificateChain(CallbackHandler handler, X509Certificate[] certPath, URI uri, CertStore certStore) throws CertificateException, CertStoreException {
        CertStore tempCertStore = KeyStoreService.joinCertStore(this.getCertStore(handler), certStore);
        return super.getValidateCertificateChain(handler, certPath, uri, tempCertStore);
    }

    public X509Certificate[] getNormalizedCertificateChain(CallbackHandler handler, X509Certificate[] certPath, CertStore certStore) throws CertificateException, CertStoreException {
        CertStore tempCertStore = KeyStoreService.joinCertStore(this.getCertStore(handler), certStore);
        return super.getNormalizedCertificateChain(certPath, tempCertStore);
    }

    public boolean extendendValidationCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri) {
        return this.extendendValidationCertificateChain(handler, certChain, uri, null);
    }

    public boolean extendendValidationCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri, CertStore certStore) {
        try {
            CertStore tempCertStore = KeyStoreService.joinCertStore(this.getCertStore(handler), certStore);
            return super.extendendValidationCertificateChain(handler, certChain, uri, tempCertStore);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean validateCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri) {
        return this.validateCertificateChain(handler, certChain, uri, null);
    }

    public boolean validateCertificateChain(CallbackHandler handler, X509Certificate[] certChain, URI uri, CertStore certStore) {
        try {
            CertStore tempCertStore = KeyStoreService.joinCertStore(this.getCertStore(handler), certStore);
            return super.validateCertificateChain(handler, certChain, uri, tempCertStore);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    private void initialize() {
        Certificate cert;
        String strAlias;
        Enumeration<String> enumCertificates;
        FileInputStream is;
        String filename;
        KeyStore keystore = null;
        String password = "changeit";
        ArrayList<Certificate> collCertificates = new ArrayList<Certificate>();
        try {
            filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            is = new FileInputStream(filename);
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, password.toCharArray());
            enumCertificates = keystore.aliases();
            while (enumCertificates.hasMoreElements()) {
                strAlias = enumCertificates.nextElement();
                cert = keystore.getCertificate(strAlias);
                collCertificates.add(cert);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        try {
            filename = System.getProperty("javax.net.ssl.trustStore");
            password = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword") : password;
            is = new FileInputStream(filename);
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, password.toCharArray());
            enumCertificates = keystore.aliases();
            while (enumCertificates.hasMoreElements()) {
                strAlias = enumCertificates.nextElement();
                cert = keystore.getCertificate(strAlias);
                collCertificates.add(cert);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(collCertificates);
        try {
            this.defaultTrustCertStore = CertStore.getInstance("Collection", collCSP);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)e, (Throwable)e);
        }
    }

    public X509Certificate[] getCertChainFromStore(String id) {
        if (certMap.containsKey(id)) {
            try {
                ArrayList<X509HigginsCertificate> certPath = new ArrayList<X509HigginsCertificate>();
                for (X509CertificateEntity entity = (X509CertificateEntity)certMap.get(id); entity != null; entity = entity.getSignedBy()) {
                    X509Certificate[] certs = KeyStoreServiceImp.getCertificatesFromByteArray(entity.getEncodedCertificate());
                    if (certs == null || certs.length <= 0) continue;
                    certPath.add(new X509HigginsCertificate(certs[0]));
                }
                return certPath.toArray(new X509Certificate[certPath.size()]);
            }
            catch (CertificateException e) {
                this.log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void modifyCertChain(X509CertificateEntity certificateEntity, boolean force) throws CertStoreException {
        try {
            if (force || !certMap.containsKey(certificateEntity.getId())) {
                certMap.put(certificateEntity.getId(), certificateEntity);
                this.log.debug((Object)("put certificate id:" + certificateEntity.getId()));
            }
        }
        catch (Exception e) {
            throw new CertStoreException(e);
        }
    }

    private void modifyCertChain(X509Certificate[] certificatePath, boolean force) throws CertStoreException {
        try {
            this.modifyCertChain(ConvertHelper.convertCertChainToEntity(certificatePath), force);
        }
        catch (Exception e) {
            throw new CertStoreException(e);
        }
    }

    public void putCertChain(X509Certificate[] certificatePath) throws CertStoreException {
        this.modifyCertChain(certificatePath, false);
    }

    public void updateCertChain(X509Certificate[] certificatePath) throws CertStoreException {
        this.modifyCertChain(certificatePath, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

