/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.higgins.keystore.common.utils.AllReadedByte;

public class Asn1Node {
    private int tag = 0;
    private byte[] value = new byte[0];
    private List collection = new ArrayList();
    public static final int Type_None = -1;
    public static final int Primitive = 0;
    public static final int Constructed = 1;
    public static final int Class_None = -1;
    public static final int Universal = 0;
    public static final int Application = 1;
    public static final int Ber_Context = 2;
    public static final int Private = 3;
    public static final int Z_ERROR = 0;
    public static final int Z_OK = 1;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public static Asn1Node getInstance(byte[] value) {
        try {
            ByteArrayInputStream inputBuffer = new ByteArrayInputStream(value);
            return Asn1Node.getInstance(inputBuffer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Asn1Node getInstance(InputStream stream) {
        try {
            return Asn1Node.GetAsn1Node(stream, new AllReadedByte());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Asn1Node() {
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte byte0) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == byte0;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte byte0) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == byte0;
    }

    private static Asn1Node GetAsn1Node(InputStream stream, AllReadedByte allreadbytes) throws CertificateParsingException, IOException {
        Asn1Node node = new Asn1Node();
        AllReadedByte length = new AllReadedByte();
        if (Asn1Node.GetTagValue(stream, node, allreadbytes) == 0) {
            return null;
        }
        if (node.getTag() == 0) {
            return null;
        }
        if (Asn1Node.GetLenghtValue(stream, length, allreadbytes) == 0) {
            return null;
        }
        if (length.getValue() > 0) {
            AllReadedByte readbytes = new AllReadedByte();
            if (node.isConstructed()) {
                Asn1Node node1;
                while ((node1 = Asn1Node.GetAsn1Node(stream, readbytes)) != null) {
                    node.collection.add(node1);
                    if (length.getValue() > readbytes.getValue()) continue;
                    break;
                }
            } else {
                byte[] temp = new byte[length.getValue()];
                int i = 0;
                while (i < length.getValue()) {
                    temp[i] = (byte)stream.read();
                    readbytes.Plus();
                    ++i;
                }
                node.value = temp;
            }
            allreadbytes.Plus(readbytes);
        } else if (length.getValue() == -1) {
            Asn1Node node1;
            AllReadedByte readbytes = new AllReadedByte();
            while ((node1 = Asn1Node.GetAsn1Node(stream, readbytes)) != null) {
                node.collection.add(node1);
            }
        } else {
            node.value = new byte[0];
        }
        return node;
    }

    private static int GetTagValue(InputStream stream, Asn1Node node, AllReadedByte readbytes) throws CertificateParsingException, IOException {
        int result;
        int tagno;
        block8: {
            tagno = 0;
            int ch = stream.read();
            readbytes.Plus();
            if (ch == 0) {
                ch = stream.read();
                if (ch != 0) {
                    result = 0;
                } else {
                    tagno = 0;
                    result = 1;
                    readbytes.Plus();
                }
            } else {
                tagno = ch;
                if (tagno == 31) {
                    tagno = 0;
                    while (true) {
                        if ((ch = stream.read()) == -1) {
                            result = 0;
                            break block8;
                        }
                        readbytes.Plus();
                        if (ch < 128) {
                            tagno <<= 7;
                            tagno += ch;
                            result = 1;
                            break block8;
                        }
                        tagno <<= 7;
                        tagno += (ch &= 0x7F);
                    }
                }
                result = 1;
            }
        }
        node.setTag(tagno);
        return result;
    }

    private static int GetLenghtValue(InputStream stream, AllReadedByte length, AllReadedByte readbytes) throws CertificateParsingException, IOException {
        int result;
        int i = 0;
        int len = 0;
        length.setValue(0);
        int ch = stream.read();
        if (ch == -1) {
            result = 0;
        } else {
            readbytes.Plus();
            if ((ch & 0x80) == 0) {
                result = 1;
                length.setValue(ch);
            } else if (ch == 128) {
                result = 1;
                length.setValue(-1);
            } else {
                int nocs = ch & 0x7F;
                if (nocs > 4) {
                    result = 0;
                    length.setValue(0);
                } else {
                    i = nocs;
                    while (i > 0) {
                        ch = stream.read();
                        if (ch == -1) {
                            result = 0;
                            break;
                        }
                        readbytes.Plus();
                        len <<= 8;
                        len += ch;
                        --i;
                    }
                    result = 1;
                    length.setValue(len);
                }
            }
        }
        return result;
    }

    public List getCollection() {
        return this.collection;
    }

    public void setCollection(ArrayList collection) {
        this.collection = collection;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = new byte[value.length];
        System.arraycopy(value, 0, this.value, 0, value.length);
    }

    public String getValueAsString() throws UnsupportedEncodingException {
        switch (this.getTag()) {
            case 12: {
                return this.getValueAsUTF8String();
            }
            case 19: {
                return this.getValueAsPrintableString();
            }
            case 20: {
                return this.getValueAsT61String();
            }
            case 22: {
                return this.getValueAsIA5String();
            }
            case 27: {
                return this.getValueAsGeneralString();
            }
            case 30: {
                return this.getValueAsBMPString();
            }
        }
        return null;
    }

    public String getValueAsIA5String() throws UnsupportedEncodingException {
        if (this.tag != 22) {
            throw new UnsupportedEncodingException("Value is not a IA5 string. Tag=" + this.tag);
        }
        return new String(this.value, "ASCII");
    }

    public String getValueAsBMPString() throws UnsupportedEncodingException {
        if (this.tag != 30) {
            throw new UnsupportedEncodingException("Value is not a BMP string. Tag=" + this.tag);
        }
        return new String(this.value, "UnicodeBigUnmarked");
    }

    public String getValueAsGeneralString() throws UnsupportedEncodingException {
        if (this.tag != 27) {
            throw new UnsupportedEncodingException("Value is not a GeneralString string. Tag=" + this.tag);
        }
        return new String(this.value, "ASCII");
    }

    public String getValueAsT61String() throws UnsupportedEncodingException {
        if (this.tag != 20) {
            throw new UnsupportedEncodingException("Value is not a T61 string. Tag=" + this.tag);
        }
        return new String(this.value, "ISO-8859-1");
    }

    public String getValueAsPrintableString() throws UnsupportedEncodingException {
        if (this.tag != 19) {
            throw new UnsupportedEncodingException("Value is not a string. Tag=" + this.tag);
        }
        return new String(this.value, "ASCII");
    }

    public String getValueAsUTF8String() throws UnsupportedEncodingException {
        if (this.tag != 12) {
            throw new UnsupportedEncodingException("Value is not a UTF8 string. Tag=" + this.tag);
        }
        return new String(this.value, "UTF8");
    }

    public int getInteger() throws CertificateParsingException {
        if (this.tag != 2) {
            throw new CertificateParsingException("getInteger, not an int " + this.tag);
        }
        BigInteger biginteger = this.getBigInteger();
        if (biginteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new CertificateParsingException("Integer below minimum valid value");
        }
        if (biginteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new CertificateParsingException("Integer exceeds maximum valid value");
        }
        return biginteger.intValue();
    }

    public BigInteger getBigInteger() throws CertificateParsingException {
        if (this.tag != 2) {
            throw new CertificateParsingException("getBigInteger, not an int " + this.tag);
        }
        byte[] temp = new byte[this.value.length];
        System.arraycopy(this.value, 0, temp, 0, this.value.length);
        return new BigInteger(temp);
    }
}

