/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 * PolicyQualifierInfo ::= SEQUENCE {
 *      policyQualifierId  PolicyQualifierId,
 *      qualifier          ANY DEFINED BY policyQualifierId }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 */

public class PolicyQualifierInfo {

	ObjectIdentifier policyQualifierId;

	Object qualifier;

	public PolicyQualifierInfo(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
			Asn1Node oidNode = (Asn1Node) node.getCollection().get(0);
			policyQualifierId = new ObjectIdentifier(oidNode);
			if (policyQualifierId.equals(ObjectIdentifier.id_qt_cps)) {
				Asn1Node qualifierNode = (Asn1Node) node.getCollection().get(1);
				try {
					this.qualifier = qualifierNode.getValueAsIA5String();
				} catch (UnsupportedEncodingException e) {
					throw (CertificateParsingException) (new CertificateParsingException(e.toString())).initCause(e);
				}

			} else if (policyQualifierId.equals(ObjectIdentifier.id_qt_unotice)) {
				Asn1Node qualifierNode = (Asn1Node) node.getCollection().get(1);
				this.qualifier = new UserNotice(qualifierNode);
			} else {

			}
		}
	}

	public String toString() {
		StringBuffer stringbuilder = new StringBuffer("");
		if (policyQualifierId != null || qualifier != null) {
			stringbuilder.append("PolicyQualifierInfo: [\n");
			if (policyQualifierId != null) {
				stringbuilder.append("policyQualifierId: ");
				stringbuilder.append(policyQualifierId.toString());
			}
			if (qualifier != null) {
				stringbuilder.append("\n   qualifier: ");
				stringbuilder.append(qualifier.toString());
			}
			stringbuilder.append("]\n");
		}
		return stringbuilder.toString();
	}
}
