/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.X509.GeneralName;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class AccessDescription {
    private ObjectIdentifier accessMethod;
    private GeneralName accessLocation;

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public void setAccessLocation(GeneralName accessLocation) {
        this.accessLocation = accessLocation;
    }

    public ObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public void setAccessMethod(ObjectIdentifier accessMethod) {
        this.accessMethod = accessMethod;
    }

    public AccessDescription(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty() && node.getCollection().size() >= 1) {
            Asn1Node oidNode = (Asn1Node)node.getCollection().get(0);
            this.accessMethod = new ObjectIdentifier(oidNode);
            if (node.getCollection().size() > 1) {
                Asn1Node locationNode = (Asn1Node)node.getCollection().get(1);
                this.accessLocation = new GeneralName(locationNode);
            }
        }
    }

    public String toString() {
        return "accessMethod: " + this.accessMethod.toString() + "\n   accessLocation: " + this.accessLocation.toString();
    }
}

