/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.util.Arrays;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;

public class Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical;
    protected byte[] extensionValue;

    public Extension() {
        this.critical = false;
        this.extensionValue = null;
    }

    public Extension(byte[] extensionValue, boolean critical) {
        this.extensionValue = extensionValue;
        this.critical = critical;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ObjectIdentifier getExtensionId() {
        return this.extensionId;
    }

    public byte[] getExtensionValue() {
        return this.extensionValue;
    }

    public String toString() {
        String s = "ObjectId: " + this.extensionId.toString();
        s = this.critical ? s + " Criticality=true\n" : s + " Criticality=false\n";
        return s;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.critical ? 1231 : 1237);
        result = 31 * result + (this.extensionId == null ? 0 : this.extensionId.hashCode());
        result = 31 * result + Extension.hashCode(this.extensionValue);
        return result;
    }

    private static int hashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extension other = (Extension)obj;
        if (this.critical != other.critical) {
            return false;
        }
        if (this.extensionId == null ? other.extensionId != null : !this.extensionId.equals(other.extensionId)) {
            return false;
        }
        return Arrays.equals(this.extensionValue, other.extensionValue);
    }
}

