/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 7309080005146431409L;
    protected int[] components;
    protected int componentLen;
    private volatile transient String stringForm;
    public static final String id_ce = "2.5.29";
    public static final String id_ce_certificatePolicies = "2.5.29.32";
    public static final String id_ce_anyPolicy = "2.5.29.32.0";
    public static final String id_pkix = "1.3.6.1.5.5.7";
    public static final String id_qt = "1.3.6.1.5.5.7.2";
    public static final String id_qt_cps = "1.3.6.1.5.5.7.2.1";
    public static final String id_qt_unotice = "1.3.6.1.5.5.7.2.2";
    public static final String id_pe = "1.3.6.1.5.5.7.1";
    public static final String id_pe_authorityInfoAccess = "1.3.6.1.5.5.7.1.1";
    public static final String id_ad = "1.3.6.1.5.5.7.48";
    public static final String id_ad_caIssuers = "1.3.6.1.5.5.7.48.2";
    public static final String id_ad_ocsp = "1.3.6.1.5.5.7.48.1";
    public static final String id_at = "2.5.4";
    public static final String id_at_commonName = "2.5.4.3";
    public static final String id_at_countryName = "2.5.4.6";
    public static final String id_at_localityName = "2.5.4.7";
    public static final String id_at_stateOrProvinceName = "2.5.4.8";
    public static final String id_at_organizationName = "2.5.4.10";
    public static final String id_at_organizationalUnitName = "2.5.4.11";

    public ObjectIdentifier(String s) throws CertificateParsingException {
        int byte0 = 46;
        int i = 0;
        int j = 0;
        this.componentLen = 0;
        while ((j = s.indexOf(byte0, i)) != -1) {
            i = j + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        i = 0;
        int k = 0;
        String s1 = null;
        while ((j = s.indexOf(byte0, i)) != -1) {
            s1 = s.substring(i, j);
            this.components[k++] = Integer.valueOf(s1);
            if (this.components[k++] < 0) {
                throw new CertificateParsingException("oid components must be nonnegative");
            }
            i = j + 1;
        }
        s1 = s.substring(i);
        this.components[k] = Integer.valueOf(s1);
        if (this.components[0] < 0 || this.components[0] > 2) {
            throw new CertificateParsingException("First oid component is invalid ");
        }
        if (this.components[1] < 0 || this.components[1] > 39) {
            throw new CertificateParsingException("Second oid component is invalid ");
        }
        this.stringForm = s;
    }

    public ObjectIdentifier(int[] ai) throws CertificateParsingException {
        if (ai.length >= 1 && (ai[0] < 0 || ai[0] > 2)) {
            throw new CertificateParsingException("First oid component is invalid ");
        }
        if (ai.length >= 2 && (ai[1] < 0 || ai[1] > 39)) {
            throw new CertificateParsingException("Second oid component is invalid ");
        }
        this.components = (int[])ai.clone();
        this.componentLen = ai.length;
        this.toString();
    }

    public ObjectIdentifier(byte[] value) throws CertificateParsingException {
        try {
            ByteArrayInputStream inputBuffer = new ByteArrayInputStream(value);
            this.initFromEncoding(inputBuffer, 0);
        }
        catch (IOException exc) {
            throw new CertificateParsingException(exc.getMessage());
        }
        this.toString();
    }

    public ObjectIdentifier(InputStream inputBuffer) throws CertificateParsingException {
        try {
            this.initFromEncoding(inputBuffer, 0);
        }
        catch (IOException exc) {
            throw new CertificateParsingException(exc.getMessage());
        }
        this.toString();
    }

    public ObjectIdentifier(Asn1Node node) throws CertificateParsingException {
        if (node.getTag() != 6) {
            return;
        }
        try {
            ByteArrayInputStream inputBuffer = new ByteArrayInputStream(node.getValue());
            this.initFromEncoding(inputBuffer, 0);
        }
        catch (IOException exc) {
            throw new CertificateParsingException(exc.getMessage());
        }
        this.toString();
    }

    private void initFromEncoding(InputStream inputBuffer, int i) throws IOException, CertificateParsingException {
        boolean flag = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (inputBuffer.available() > i) {
            int j = ObjectIdentifier.getComponent(inputBuffer);
            if (j < 0) {
                throw new CertificateParsingException("Component values must be nonnegative");
            }
            if (flag) {
                int byte0 = j < 40 ? 0 : (j < 80 ? 1 : 2);
                int k = j - byte0 * 40;
                if (k > 39) {
                    throw new CertificateParsingException("Invalid second component");
                }
                this.components[0] = byte0;
                this.components[1] = k;
                this.componentLen = 2;
                flag = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] ai = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, ai, 0, this.components.length);
                this.components = ai;
            }
            this.components[this.componentLen++] = j;
        }
        if (inputBuffer.available() != i) {
            throw new CertificateParsingException("Malformed input data");
        }
    }

    private static int getComponent(InputStream inputBuffer) throws IOException, CertificateParsingException {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            i <<= 7;
            int k = inputBuffer.read();
            i |= k & 0x7F;
            if ((k & 0x80) != 0) continue;
            return i;
        }
        throw new CertificateParsingException("X509.OID, component value too big");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectIdentifier) && !(obj instanceof String)) {
            return false;
        }
        if (obj instanceof String) {
            return this.stringForm.equals(obj);
        }
        ObjectIdentifier objectidentifier = (ObjectIdentifier)obj;
        if (this.componentLen != objectidentifier.componentLen) {
            return false;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (this.components[i] == objectidentifier.components[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i = this.componentLen;
        for (int j = 0; j < this.componentLen; ++j) {
            i += this.components[j] * 37;
        }
        return i;
    }

    public String toString() {
        String s = this.stringForm;
        if (s == null) {
            StringBuffer stringbuffer = new StringBuffer(this.componentLen * 4);
            for (int i = 0; i < this.componentLen; ++i) {
                if (i != 0) {
                    stringbuffer.append('.');
                }
                stringbuffer.append(this.components[i]);
            }
            this.stringForm = s = stringbuffer.toString();
        }
        return s;
    }
}

