/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.X509.PolicyQualifierInfo;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class PolicyInformation {
    private ObjectIdentifier policyIdentifier;
    private Collection policyQualifiers;

    public ObjectIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public void setPolicyIdentifier(ObjectIdentifier policyIdentifier) {
        this.policyIdentifier = policyIdentifier;
    }

    public Collection getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public void setPolicyQualifiers(Collection policyQualifiers) {
        this.policyQualifiers = policyQualifiers;
    }

    public PolicyInformation(Asn1Node node) {
        try {
            this.policyQualifiers = new ArrayList();
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty() && node.getCollection().size() >= 1) {
            Asn1Node policyQualifiersNode;
            Asn1Node oidNode = (Asn1Node)node.getCollection().get(0);
            this.policyIdentifier = new ObjectIdentifier(oidNode);
            if (node.getCollection().size() > 1 && !(policyQualifiersNode = (Asn1Node)node.getCollection().get(1)).getCollection().isEmpty()) {
                Iterator iter = policyQualifiersNode.getCollection().iterator();
                while (iter.hasNext()) {
                    this.policyQualifiers.add(new PolicyQualifierInfo((Asn1Node)iter.next()));
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringbuilder = new StringBuffer();
        stringbuilder.append("PolicyInformation: [\n");
        if (this.policyIdentifier != null) {
            stringbuilder.append("policyIdentifier: ");
            stringbuilder.append(this.policyIdentifier.toString());
        }
        if (this.policyQualifiers != null) {
            stringbuilder.append("\n   policyQualifiers: ");
            Iterator iterator = this.policyQualifiers.iterator();
            while (iterator.hasNext()) {
                PolicyQualifierInfo policyQualifier = (PolicyQualifierInfo)iterator.next();
                stringbuilder.append(policyQualifier.toString());
            }
        }
        stringbuilder.append("]\n");
        return stringbuilder.toString();
    }
}

