/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.X509.X501Name;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class TBSCertificate {
    X501Name issuerSubject = null;
    X501Name subject = null;
    int version = 1;

    public TBSCertificate(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TBSCertificate(byte[] extensionValue) {
        try {
            Asn1Node node = Asn1Node.getInstance(extensionValue);
            if (node.getTag() == 4) {
                node = Asn1Node.getInstance(node.getValue());
            }
            if (node.getTag() == 48 || node.getTag() == 48) {
                this.parse(node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty()) {
            Asn1Node firstNode = (Asn1Node)node.getCollection().get(0);
            int index = 2;
            if (firstNode.isContextSpecific()) {
                firstNode = (Asn1Node)firstNode.getCollection().get(0);
                this.version = firstNode.getInteger();
                index = 3;
            }
            if (node.getCollection().size() > index) {
                this.issuerSubject = new X501Name((Asn1Node)node.getCollection().get(index));
            }
            if (node.getCollection().size() > index + 2) {
                this.subject = new X501Name((Asn1Node)node.getCollection().get(index + 2));
            }
        }
    }

    public String toString() {
        return "";
    }

    public X501Name getIssuerSubject() {
        return this.issuerSubject;
    }

    public X501Name getSubject() {
        return this.subject;
    }

    public int getVersion() {
        return this.version;
    }
}

