/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.X509.URIName;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class GeneralName {
    private Object value = null;

    public GeneralName(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {}
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (node != null) {
            this.value = null;
            byte word0 = (byte)(node.getTag() & 0x1F);
            switch (word0) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    if (node.isContextSpecific() && !node.isConstructed()) {
                        node.setTag(22);
                        this.value = new URIName(node);
                        break;
                    }
                    throw new CertificateParsingException("Invalid encoding of URI");
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    throw new CertificateParsingException("Unrecognized GeneralName tag, (" + word0 + ")");
                }
            }
        }
    }

    public String toString() {
        return this.value.toString();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

