/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.X509.UserNotice;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class PolicyQualifierInfo {
    ObjectIdentifier policyQualifierId;
    Object qualifier;

    public PolicyQualifierInfo(Asn1Node node) {
        try {
            this.parse(node);
        }
        catch (Exception exception) {}
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
            Asn1Node oidNode = (Asn1Node)node.getCollection().get(0);
            this.policyQualifierId = new ObjectIdentifier(oidNode);
            if (this.policyQualifierId.equals("1.3.6.1.5.5.7.2.1")) {
                Asn1Node qualifierNode = (Asn1Node)node.getCollection().get(1);
                try {
                    this.qualifier = qualifierNode.getValueAsIA5String();
                }
                catch (UnsupportedEncodingException e) {
                    throw (CertificateParsingException)new CertificateParsingException(e.toString()).initCause(e);
                }
            } else if (this.policyQualifierId.equals("1.3.6.1.5.5.7.2.2")) {
                Asn1Node qualifierNode = (Asn1Node)node.getCollection().get(1);
                this.qualifier = new UserNotice(qualifierNode);
            }
        }
    }

    public String toString() {
        StringBuffer stringbuilder = new StringBuffer("");
        if (this.policyQualifierId != null || this.qualifier != null) {
            stringbuilder.append("PolicyQualifierInfo: [\n");
            if (this.policyQualifierId != null) {
                stringbuilder.append("policyQualifierId: ");
                stringbuilder.append(this.policyQualifierId.toString());
            }
            if (this.qualifier != null) {
                stringbuilder.append("\n   qualifier: ");
                stringbuilder.append(this.qualifier.toString());
            }
            stringbuilder.append("]\n");
        }
        return stringbuilder.toString();
    }
}

