/** 
 * Copyright (c)  ${year}  Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.keystore.common.entity;

import java.io.Serializable;

/**
 * @author Alexander Yuhimenko
 *
 */
public class X509CertificateEntity implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3466987423584773126L;
	private byte[] encodedCertificate;
	private String id;
	private X509CertificateEntity signedBy;
	
	public boolean equals(final Object obj) {
		if (obj instanceof X509CertificateEntity && this.id != null) return this.id.equals(((X509CertificateEntity) obj).getId());
		return false;
	}
	
	public byte[] getEncodedCertificate() {
		return this.encodedCertificate;
	}
	
	public String getId() {
		return this.id;
	}
	
	public X509CertificateEntity getSignedBy() {
		return this.signedBy;
	}
	
	public int hashCode() {
		return this.id.hashCode();
	}
	
	public void setEncodedCertificate(final byte[] encodedCertificate) {
		this.encodedCertificate = encodedCertificate;
	}
	
	public void setId(final String id) {
		this.id = id;
	}
	
	public void setSignedBy(final X509CertificateEntity signedBy) {
		this.signedBy = signedBy;
	}
	
}
