package org.eclipse.higgins.keystore.common.utils;

import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;

import org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate;
import org.eclipse.higgins.keystore.common.entity.X509CertificateEntity;

public class ConvertHelper {

	public static X509CertificateEntity convertCertChainToEntity(final X509Certificate [] certificatePath) throws CertStoreException {
		return convertCertChainToEntity(certificatePath,0);
	}
	private static X509CertificateEntity convertCertChainToEntity(final X509Certificate [] certificatePath, int i) throws CertStoreException {
		if (certificatePath!= null && certificatePath.length>i)
		{
			try {
				X509HigginsCertificate cert=null;
				if (certificatePath[i] instanceof X509HigginsCertificate)
					cert=(X509HigginsCertificate)certificatePath[i];
				else
					cert=new X509HigginsCertificate(certificatePath[i]);
				
				X509CertificateEntity entity=new X509CertificateEntity();
				entity.setEncodedCertificate(cert.getEncoded());
				entity.setId(cert.getFingerprintSHA1());
				entity.setSignedBy(convertCertChainToEntity(certificatePath,i+1));
				return entity;
			} catch (final Exception e) {
				throw new CertStoreException(e);
			}
		}
		return null;
	}
	public static X509HigginsCertificate getX509HigginsCertificate(X509Certificate certificate)
	{
		if (certificate instanceof X509HigginsCertificate)
        	return (X509HigginsCertificate)certificate;
  		else
  			return new X509HigginsCertificate(certificate);
	}
}
