/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *    certificatePolicies ::= SEQUENCE SIZE (1..MAX) OF PolicyInformation
 * </pre>
 * 
 * @author Artem Verkhovets
 * 
 */

public class CertificatePoliciesExtension extends Extension {
	private Collection certificatePolicies;

	public CertificatePoliciesExtension(byte[] extensionValue, boolean critical) {
		super();
		certificatePolicies = new ArrayList();
		this.critical = critical;
		this.extensionValue = extensionValue;
		try {
			this.extensionId = new ObjectIdentifier(ObjectIdentifier.id_ce_certificatePolicies);
			Asn1Node node = Asn1Node.getInstance(extensionValue);
			if (node.getTag() == Asn1Node.tag_OctetString)
				node = Asn1Node.getInstance(node.getValue());

			if (node.getTag() == Asn1Node.tag_Sequence || node.getTag() == Asn1Node.tag_SequenceOf)
				parse(node);
		} catch (Exception exc) {
		}
	}

	public Collection getCertificatePolicies() {
		return certificatePolicies;
	}

	public void setCertificatePolicies(Collection certificatePolicies) {
		this.certificatePolicies = certificatePolicies;
	}

	private void parse(Asn1Node node) {
		if (!node.getCollection().isEmpty()) {
			for (Iterator iter = node.getCollection().iterator(); iter.hasNext();) {
				certificatePolicies.add(new PolicyInformation((Asn1Node) iter.next()));
			}
		}
	}

	public String toString() {
		if (certificatePolicies == null)
			return "";
		StringBuffer stringbuilder = new StringBuffer(super.toString());
		stringbuilder.append("CertificatePolicies [\n");
		PolicyInformation policyinformation;
		for (Iterator iterator = certificatePolicies.iterator(); iterator.hasNext(); stringbuilder.append(policyinformation.toString()))
			policyinformation = (PolicyInformation) iterator.next();

		stringbuilder.append("]\n");
		return stringbuilder.toString();
	}
}
