package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 * TBSCertificate  ::=  SEQUENCE  {
 *      version         [0]  EXPLICIT Version DEFAULT v1,
 *      serialNumber         CertificateSerialNumber,
 *      signature            AlgorithmIdentifier,
 *      issuer               Name,
 *      validity             Validity,
 *      subject              Name,
 *      subjectPublicKeyInfo SubjectPublicKeyInfo,
 *      issuerUniqueID  [1]  IMPLICIT UniqueIdentifier OPTIONAL,
 *                           -- If present, version MUST be v2 or v3
 *      subjectUniqueID [2]  IMPLICIT UniqueIdentifier OPTIONAL,
 *                           -- If present, version MUST be v2 or v3
 *      extensions      [3]  EXPLICIT Extensions OPTIONAL
 *                           -- If present, version MUST be v3
 *      }
 * <pre>	
 * @author Artem Verkhovets
 *
 */
public class TBSCertificate {
	
	X501Name issuerSubject=null;
	X501Name subject=null;
	int version = 1;
	
	public TBSCertificate(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}
	
	public TBSCertificate(byte[] extensionValue) {
		try {			
			Asn1Node node = Asn1Node.getInstance(extensionValue);
			if (node.getTag() == Asn1Node.tag_OctetString)
				node = Asn1Node.getInstance(node.getValue());

			if (node.getTag() == Asn1Node.tag_Sequence || node.getTag() == Asn1Node.tag_SequenceOf)
				parse(node);
		} catch (Exception exc) {
		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty()) {
			Asn1Node firstNode = (Asn1Node)node.getCollection().get(0);
			int index = 2;
			if (firstNode.isContextSpecific())
			{
				firstNode=(Asn1Node)firstNode.getCollection().get(0);
				version=firstNode.getInteger();
				index = 3;
			}
			if (node.getCollection().size()>index)
			{
				issuerSubject = new X501Name((Asn1Node)node.getCollection().get(index));
			}
			if (node.getCollection().size()>(index+2))
			{
				subject = new X501Name((Asn1Node)node.getCollection().get(index+2));
			}
		}
	}

	public String toString() {
		return "";
	}

	public X501Name getIssuerSubject() {
		return issuerSubject;
	}

	public X501Name getSubject() {
		return subject;
	}

	public int getVersion() {
		return version;
	}
}
