/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 *    UserNotice ::= SEQUENCE {
 *      noticeRef        NoticeReference OPTIONAL,
 *      explicitText     DisplayText OPTIONAL}
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 * 
 */

public class UserNotice {

	NoticeReference noticeRef;

	DisplayText explicitText;

	public UserNotice(Asn1Node node) {
		try {
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty()) {
			for (int i = 0; i < node.getCollection().size(); i++) {
				Asn1Node subNode = (Asn1Node) node.getCollection().get(i);
				if (subNode.getTag() == Asn1Node.tag_Sequence) {
					explicitText = new DisplayText(subNode);
				} else {
					noticeRef = new NoticeReference(subNode);
				}
			}
		}
	}

	public String toString() {
		StringBuffer stringbuilder = new StringBuffer("");
		if (noticeRef != null || explicitText != null) {
			stringbuilder.append("UserNotice: [\n");
			if (noticeRef != null) {
				stringbuilder.append("noticeRef: ");
				stringbuilder.append(noticeRef.toString());
			}
			if (explicitText != null) {
				stringbuilder.append("\n   explicitText: ");
				stringbuilder.append(explicitText.toString());
			}
			stringbuilder.append("]\n");
		}
		return stringbuilder.toString();
	}
}
