package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateParsingException;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class X501Name {

	private Hashtable value = null;

	private static Hashtable Keywords = new Hashtable();

	public X501Name(Asn1Node node) {
		try {
			value = new Hashtable();
			parse(node);
		} catch (Exception exc) {

		}
	}

	public String getAttributeValue(ObjectIdentifier oid) {
		return (String) value.get(oid);
	}

	public String getAttributeValueByName(String name) {
		try {
			String oid = (String) Keywords.get(name.toUpperCase());
			if (oid != null)
				return (String) value.get(new ObjectIdentifier(oid));
		} catch (Exception exc) {

		}
		return null;
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty()) {
			for (Iterator iter = node.getCollection().iterator(); iter.hasNext();) {
				parseRND((Asn1Node) iter.next());
			}
		}
	}

	private void parseRND(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty()) {
			for (Iterator iter = node.getCollection().iterator(); iter.hasNext();) {
				parseAttributeTypeAndValue((Asn1Node) iter.next());
			}
		}		
	}

	private void parseAttributeTypeAndValue(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty() && node.getCollection().size() == 2) {
			ObjectIdentifier key = new ObjectIdentifier((Asn1Node) node.getCollection().get(0));
			String valueKey = null;
			try {
				valueKey = ((Asn1Node) node.getCollection().get(1)).getValueAsString();
			} catch (UnsupportedEncodingException e) {
				throw (CertificateParsingException) (new CertificateParsingException(e.toString())).initCause(e);
			}
			if (valueKey != null)
				value.put(key, valueKey);
		}
	}

	static {
		Keywords.put("CN", ObjectIdentifier.id_at_commonName);
		Keywords.put("C", ObjectIdentifier.id_at_countryName);
		Keywords.put("L", ObjectIdentifier.id_at_localityName);
		Keywords.put("ST", ObjectIdentifier.id_at_stateOrProvinceName);
		Keywords.put("O", ObjectIdentifier.id_at_organizationName);
		Keywords.put("OU", ObjectIdentifier.id_at_organizationalUnitName);
	}
}
