package org.eclipse.higgins.keystore;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.CallbackHandler;

import org.eclipse.higgins.registry.IServiceProvider;

public interface IKeyStoreService extends IServiceProvider{

	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri);
	
	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri, CertStore certStore);
	
	public X509Certificate [] getNormalizedCertificateChain(CallbackHandler handler,X509Certificate [] certPath, CertStore certStore) throws CertificateException, CertStoreException;
	
	public X509Certificate [] getValidateCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri) throws CertificateException, CertStoreException;
	
	public X509Certificate [] getValidateCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri, CertStore certStore) throws CertificateException, CertStoreException;
	
	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri, CertStore certStore);
	
	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate [] certPath, URI uri);

	public X509Certificate findLeafFromCertificates(X509Certificate [] listCerts);
	
	public CertStore getDefaultCertStore(CallbackHandler handler);

	public CertStore getCertStore(CallbackHandler handler) throws CertificateException, CertStoreException;
	
	public CertStore addToCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException;
	
	public CertStore addToCertStore(CallbackHandler handler,X509Certificate [] certificates) throws CertificateException, CertStoreException;
		
	public CertStore deleteFromCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException;
	
	public CertStore deleteFromCertStore(CallbackHandler handler,X509Certificate [] certificates) throws CertificateException, CertStoreException;
}
