/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.messages.utilities;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MsgHelper {

	// These definitions are copied from STSMessages.java to reduce probability of runtime errors
    public static final String settinghandler_not_found_for_type = "settinghandler_not_found_for_type"; 
    public static final String not_initialized = "not_initialized"; 
    public static final String invocationtargetexception_cause = "invocationtargetexception_cause"; 
    public static final String request_failed_with_exception = "request_failed_with_exception"; 
    public static final String stacktraceelement_format_msg = "stacktraceelement_format_msg"; 
    public static final String log_throwable_is_null = "log_throwable_is_null"; 
    public static final String no_extension_configuration_found = "no_extension_configuration_found"; 
    public static final String elementname_is_null = "elementname_is_null"; 
    public static final String elementname_result_is_null = "elementname_result_is_null"; 
    public static final String found_more_than_one_element = "found_more_than_one_element"; 
    public static final String element_not_found_in_config = "element_not_found_in_config"; 
    public static final String invalid_string_representationformat_cuid = "invalid_string_representationformat_cuid"; 
    public static final String argument_cant_be_null = "argument_cant_be_null"; 
    public static final String failed_to_get_object = "failed_to_get_object"; 
    public static final String no_stub_implementation = "no_stub_implementation"; 
    public static final String cannot_set_endpoint_address_unknown_port = "cannot_set_endpoint_address_unknown_port"; 
    public static final String failure_getting_call_object = "failure_getting_call_object"; 
    public static final String caught_exception = "caught_exception"; 
    public static final String unsupported_ielement_set = "unsupported_ielement_set"; 
    public static final String securitytoken_from_securityinformation_is_null = "securitytoken_from_securityinformation_is_null";
    
	
    
    private static ResourceBundle resourceBundle = null;
    private static final String RESOURCE_BUNDLE_NAME = 
        						"org.eclipse.higgins.messages.STSMessages";
    /**
     * Current thread lock for synchronization.
     * <p>
     */
    protected static final Object LOCK = new Object();
    
    public static String getString(String key) {

        synchronized(LOCK){
            
            //Load the resource bundle:
            if (resourceBundle == null) { 
                //Attempt to load the resource bundle:
                if (resourceBundle == null) {       
                    try {
                        resourceBundle = ResourceBundle.getBundle(              																RESOURCE_BUNDLE_NAME);
                    }
                    catch (MissingResourceException m) {
                        return key;
                    }
                }
            }
    
            try {
                return (resourceBundle.getString(key.trim()).trim());
            }
            catch (Exception e) {
            }
        }        

        return key;
    }

    public static String getString(String key, Object argument) {
        return (getString(key, new Object[] { argument}));
    }

    public static String getString(String key, Object argumentA, Object argumentB) {
        return (getString(key, new Object[] { argumentA, argumentB}));
    }

    public static String getString(String key, Object argumentA, Object argumentB, Object argumentC) {
        return (getString(key, new Object[] { argumentA, argumentB, argumentC}));
    }

    public static String getString(String key, Object argumentA, Object argumentB, Object argumentC, 
			Object argumentD) {
        return (getString(key, new Object[] { argumentA, argumentB, argumentC, argumentD}));
    }
    
    public static String getString(String key, Object argumentA, Object argumentB, Object argumentC, 
			Object argumentD, Object argumentE) {
        return (getString(key, new Object[] { argumentA, argumentB, argumentC, argumentD, argumentE}));
    }

    public static String getString(String key, Object[] arguments) {

        try {
        	String strMessage = MessageFormat.format(getString(key), arguments);
        	System.err.println(strMessage);
        	return (strMessage);
        }
        catch (Exception e) {
            return key;
        }
    }
}

