/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;

public abstract class HigginsRegistry {
    protected List extensions = new ArrayList();
    protected HashMap providers = new HashMap();
    protected Class type;
    protected String configPath = System.getProperty("user.home") + File.separator + ".higgins";

    public HigginsRegistry(Class type) {
        this(type, System.getProperty("user.home") + File.separator + ".higgins");
    }

    public HigginsRegistry(Class type, String configPath) {
        this.type = type;
        this.configPath = configPath;
    }

    public void addExtension(IRegistryExtension ext) {
        if (!this.extensions.contains(ext)) {
            this.extensions.add(ext);
        }
    }

    public void loadProviders() {
        for (int i = 0; i < this.extensions.size(); ++i) {
            IRegistryExtension e = (IRegistryExtension)this.extensions.get(i);
            this.loadProviders(e);
        }
    }

    protected void loadProviders(IRegistryExtension e) {
        Iterator itr = e.getServiceProviders();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof IServiceProvider) {
                this.add((IServiceProvider)o);
                continue;
            }
            this.add(o);
        }
    }

    public synchronized Iterator getServiceProviders() {
        return this.providers.values().iterator();
    }

    public synchronized Object getServiceProvider(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument \"id\" can't be null.");
        }
        return this.providers.get(id);
    }

    protected synchronized void add(Object provider) {
        if (provider == null) {
            new IllegalArgumentException("Argument \"provider\" can't be null.");
        }
        if (this.type.isInstance(provider)) {
            if (provider instanceof IServiceProvider) {
                this.add((IServiceProvider)provider);
            } else {
                String id = provider.getClass().getName();
                if (this.providers.get(id) == null) {
                    this.providers.put(id, provider);
                }
            }
        } else {
            System.err.println(this.getClass().getName() + "::add(Object provider) provider=\"" + provider + "\" is not instance of \"" + this.type + "\"");
        }
    }

    protected synchronized void add(IServiceProvider provider) {
        String id = provider.getID();
        if (id == null) {
            new IllegalArgumentException("Provider's ID can't be null.").printStackTrace();
            return;
        }
        if (this.providers.get(id) == null) {
            IConfiguration config = provider.getConfiguration();
            File f = this.getConfigFile(id);
            if (config != null) {
                config.load(f);
            }
            this.providers.put(id, provider);
        }
    }

    public synchronized void remove(IServiceProvider provider) {
        String id;
        if (provider == null) {
            new IllegalArgumentException("Argument \"provider\" can't be null.");
        }
        if ((id = provider.getID()) == null) {
            new IllegalArgumentException("Provider's ID can't be null.");
        }
        this.providers.remove(id);
    }

    public File getConfigFile(String id) {
        return new File(this.getConfigPath() + File.separator + id + ".ini");
    }

    public String getConfigPath() {
        return this.configPath + File.separator + this.getConfigFolder();
    }

    protected abstract String getConfigFolder();
}

