/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryException;

public abstract class PluginRegistryExtension
implements IRegistryExtension {
    protected String xpid = null;

    public PluginRegistryExtension(String xpid) {
        this.xpid = xpid;
    }

    public abstract IServiceProvider createProvider(IExtension var1, IConfigurationElement var2) throws RegistryException;

    public Iterator getServiceProviders() {
        ArrayList<IServiceProvider> list = new ArrayList<IServiceProvider>();
        try {
            IExtensionRegistry r = Platform.getExtensionRegistry();
            if (r == null) {
                return list.iterator();
            }
            IExtensionPoint extensionPoint = r.getExtensionPoint(this.xpid);
            if (extensionPoint == null) {
                return list.iterator();
            }
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                for (int j = 0; j < elements.length; ++j) {
                    IConfigurationElement element = elements[j];
                    IServiceProvider p = null;
                    try {
                        p = this.createProvider(extension, element);
                        if (p == null) continue;
                        list.add(p);
                        continue;
                    }
                    catch (RegistryException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.iterator();
    }
}

