/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import sun.misc.ServiceConfigurationError;

public class IIORegistryExtension
implements IRegistryExtension {
    private Class type;

    public IIORegistryExtension(Class type) {
        this.type = type;
    }

    public Iterator getServiceProviders() {
        ArrayList list = new ArrayList(this.getInstalledProviders());
        list.addAll(this.getRuntimeProviders());
        return list.iterator();
    }

    private static Iterator providers(Class providerClass, ClassLoader loader) {
        if (providerClass == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return ServiceRegistry.lookupProviders(providerClass, loader);
    }

    private static Iterator providers(Class providerClass) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return IIORegistryExtension.providers(providerClass, cl);
    }

    private static Iterator installedProviders(Class type) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        ClassLoader prev = null;
        while (cl != null) {
            prev = cl;
            cl = cl.getParent();
        }
        return IIORegistryExtension.providers(type, prev);
    }

    private List getInstalledProviders() {
        final ArrayList list = new ArrayList();
        PrivilegedAction doRegistration = new PrivilegedAction(){

            public Object run() {
                Iterator providers = IIORegistryExtension.installedProviders(IIORegistryExtension.this.type);
                while (providers.hasNext()) {
                    Object o = providers.next();
                    if (!(o instanceof IServiceProvider)) {
                        System.err.println("WARNING: object=\"" + o + "\" is not instance of IServiceProvider");
                    }
                    list.add(o);
                }
                return this;
            }
        };
        AccessController.doPrivileged(doRegistration);
        return list;
    }

    private List getRuntimeProviders() {
        ArrayList list = new ArrayList();
        Iterator providers = IIORegistryExtension.providers(this.type);
        while (providers.hasNext()) {
            try {
                Object o = providers.next();
                if (!(o instanceof IServiceProvider)) {
                    System.err.println("WARNING: object=\"" + o + "\" is not instance of IServiceProvider");
                }
                list.add(o);
            }
            catch (ServiceConfigurationError err) {
                if (System.getSecurityManager() != null) {
                    err.printStackTrace();
                    continue;
                }
                throw err;
            }
        }
        return list;
    }
}

