/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.higgins.registry.IRegistryExtension;

public class SecurityRegistryExtension
implements IRegistryExtension {
    private final Class type;

    public SecurityRegistryExtension(Class type) {
        this.type = type;
    }

    public Iterator getServiceProviders() {
        return this.lookupProviders();
    }

    private Iterator lookupProviders() {
        ArrayList list = new ArrayList();
        Provider[] p = Security.getProviders();
        int i = 0;
        while (i < p.length) {
            Set<Map.Entry<Object, Object>> serv = p[i].entrySet();
            Iterator<Map.Entry<Object, Object>> itr = serv.iterator();
            while (itr.hasNext()) {
                Map.Entry<Object, Object> s = itr.next();
                if (!((Object)s).equals(this.getServiceType())) continue;
                try {
                    Class<?> c = Class.forName(s.toString());
                    if (!this.type.isAssignableFrom(c)) continue;
                    list.add(c.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return list.iterator();
    }

    private String getServiceType() {
        return this.type.getName();
    }
}

