/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry;

import java.io.File;
import java.util.Iterator;

/**
 * If service provider requires to load its configuration from persistent
 * storage it should provide an instance that implements this interface by
 * {@link org.eclipse.higgins.registry.IServiceProvider#getConfiguration()}.
 * 
 * Higgins Registry uses returned instance to load service provider
 * configuration from persistent storage when service provider is registering in
 * the registry.
 */
public interface IConfiguration {
	/**
	 * Loads configuration from the specified file.
	 * 
	 * @param config
	 *            the file to load configuration from
	 */
	public void load(File config);

	/**
	 * Saves configuration to the specified file.
	 * 
	 * @param config
	 *            the file to store configuration
	 */
	public void save(File config);

	/**
	 * Provides set of configuration property names.
	 * 
	 * @return an {@link Iterable} set of {@link String}s
	 */
	public Iterator getPropertyNames();

	/**
	 * Searches for the configuration property with the specified key in this
	 * configuration. The method returns null if the property is not found.
	 * 
	 * @param key
	 *            the property key
	 * @return the value in this configuration with the specified key value
	 */
	public String getProperty(String key);

	/**
	 * Searches for the configuration property with the specified key in this
	 * configuration. The method returns <code>defaultValue</code> if the
	 * property is not found.
	 * 
	 * @param key
	 *            the property key
	 * @param defaultValue
	 *            a default value
	 * @return the value in this configuration with the specified key value
	 */
	public String getProperty(String key, String defaultValue);
}
