/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryException;

public abstract class PluginRegistryExtension
implements IRegistryExtension {
    protected String xpid = null;

    public PluginRegistryExtension(String xpid) {
        this.xpid = xpid;
    }

    public abstract IServiceProvider createProvider(IExtension var1, IConfigurationElement var2) throws RegistryException;

    public Iterator getServiceProviders() {
        ArrayList<IServiceProvider> list = new ArrayList<IServiceProvider>();
        try {
            IExtensionRegistry r = Platform.getExtensionRegistry();
            if (r == null) {
                return list.iterator();
            }
            IExtensionPoint extensionPoint = r.getExtensionPoint(this.xpid);
            if (extensionPoint == null) {
                return list.iterator();
            }
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    IServiceProvider p = null;
                    try {
                        p = this.createProvider(extension, element);
                        if (p != null) {
                            list.add(p);
                        }
                    }
                    catch (RegistryException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.iterator();
    }
}

