/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * This implementation of
 * {@link org.eclipse.higgins.registry.IRegistryExtension} uses
 * {@link java.security.Security} mechanism to lookup for available
 * service providers.
 * 
 * @see org.eclipse.higgins.registry.IRegistryExtension
 * @see java.security.Security
 * 
 * @param <E>
 *            the service provider type to search for
 */
public class SecurityRegistryExtension implements
		IRegistryExtension {

	private final Class type;

	public SecurityRegistryExtension(Class type) {
		this.type = type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.registry.IRegistryExtension#getServiceProviders()
	 */
	public Iterator getServiceProviders() {
		return lookupProviders();
	}

	/**
	 * Locates and incrementally instantiates the available service providers of
	 * a given service and type.
	 * 
	 * Returns all available service providers.
	 */
	private Iterator lookupProviders() {
		List list = new ArrayList();
		Provider p[] = Security.getProviders();

		for (int i = 0; i < p.length; i++) {
			Set serv = p[i].entrySet();
			for (Iterator itr = serv.iterator(); itr.hasNext(); ) {
				Object s = itr.next();
				if (s.equals(getServiceType())) {
					try {
						Class c = Class.forName(s.toString());
						if (type.isAssignableFrom(c)) {
							list.add(c.newInstance());
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}

		return list.iterator();
	}

	private String getServiceType() {
		return type.getName();
	}

}
