/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.icard.token.identity;

import java.io.Serializable;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.xml.security.utils.Base64;
import org.eclipse.higgins.rp.icard.token.identity.Attribute;
import org.eclipse.higgins.rp.icard.token.identity.IIterable;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DigitalIdentity
implements Serializable,
IIterable {
    private static final boolean beTolerantOfNamespace = true;
    private String ppid;
    private Map fqnToAttrs = new HashMap();
    private static final long serialVersionUID = 1L;
    private static final String PPID_SUFFIX = "privatepersonalidentifier";
    private static final String PPIDS = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    static /* synthetic */ Class class$0;

    public String getPpid() {
        return this.ppid;
    }

    public synchronized void addAttribute(Attribute attr) {
        String fqn = attr.getFQN();
        Vector<Attribute> v1 = (Vector<Attribute>)this.fqnToAttrs.get(fqn);
        Vector<Attribute> v2 = null;
        v2 = v1 == null ? new Vector<Attribute>() : v1;
        v2.add(attr);
        if (v2 != v1) {
            this.fqnToAttrs.put(fqn, v2);
        }
        if (PPIDS.equals(fqn) || fqn.endsWith(PPID_SUFFIX)) {
            if (this.ppid != null) {
                throw new RuntimeException("multiple PPIDs not supported");
            }
            this.ppid = attr.getValue();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DigitalIdentity :\n");
        Iterator iter = this.getIterator();
        while (iter.hasNext()) {
            sb.append("\t").append(((Attribute)iter.next()).toString()).append("\n");
        }
        return sb.toString();
    }

    public String[] toStrings() {
        Vector<String> ans = new Vector<String>();
        Iterator i = this.getIterator();
        while (i.hasNext()) {
            ans.add(i.next().toString());
        }
        return ans.toArray(new String[0]);
    }

    public static DigitalIdentity fromXml(IElement input) throws Exception {
        DigitalIdentity di = new DigitalIdentity();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Element domE = (Element)input.getAs((Class)clazz);
        String ns = domE.getNamespaceURI();
        NodeList nl = domE.getElementsByTagNameNS(ns, "Attribute");
        int i = 0;
        while (i < nl.getLength()) {
            Attribute attr = DigitalIdentity.processAttribute((Element)nl.item(i));
            di.addAttribute(attr);
            ++i;
        }
        if (di.ppid == null) {
            throw new RuntimeException("XML element does not contain http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
        }
        return di;
    }

    public static DigitalIdentity fromEmailAddress(String emailAddress) throws Exception {
        String empty = "";
        String utf8 = "utf8";
        DigitalIdentity di = new DigitalIdentity();
        if (emailAddress == null || empty.equals(emailAddress)) {
            throw new NullPointerException("need emailAddress");
        }
        byte[] bytes = emailAddress.getBytes(utf8);
        MessageDigest md = MessageDigest.getInstance("SHA5");
        byte[] digBytes = md.digest(bytes);
        Base64.encode((byte[])digBytes);
        return di;
    }

    private static Attribute processAttribute(Element attrE) {
        String name = attrE.getAttribute("AttributeName");
        String namespace = attrE.getAttribute("AttributeNamespace");
        String value = XMLHelper.getTextContent((Element)((Element)attrE.getElementsByTagNameNS(attrE.getNamespaceURI(), "AttributeValue").item(0)));
        return new Attribute(name, namespace, value);
    }

    public Iterator getIterator() {
        return new DigitalIdentityIterator();
    }

    class DigitalIdentityIterator
    implements Iterator {
        Iterator mapEntry;
        int vectorCursor;
        String currentFqn;
        Vector currentV;

        DigitalIdentityIterator() {
            this.mapEntry = DigitalIdentity.this.fqnToAttrs.entrySet().iterator();
            this.vectorCursor = 0;
            this.currentFqn = null;
            this.currentV = null;
        }

        public boolean hasNext() {
            boolean ans = false;
            if (this.mapEntry.hasNext() || this.currentV != null && this.vectorCursor < this.currentV.size()) {
                ans = true;
            }
            return ans;
        }

        public Object next() {
            Object ans;
            block5: {
                block6: {
                    ans = null;
                    if (!this.hasNext()) break block5;
                    if (this.currentV != null && this.vectorCursor < this.currentV.size()) break block6;
                    if (!this.mapEntry.hasNext()) break block5;
                    this.currentV = (Vector)((Map.Entry)this.mapEntry.next()).getValue();
                    this.vectorCursor = 0;
                }
                if (this.currentV != null && this.vectorCursor < this.currentV.size()) {
                    ans = this.currentV.get(this.vectorCursor++);
                }
            }
            if (ans == null) {
                throw new NoSuchElementException();
            }
            return ans;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

