/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.icard;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.rp.icard.token.identity.Attribute;
import org.eclipse.higgins.rp.icard.token.identity.DigitalIdentity;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;
import org.eclipse.higgins.rp.util.RPClaimImpl;
import org.eclipse.higgins.rp.util.RPClaimTypeImpl;

public class ICardRPToken implements RPSecurityToken {
	DigitalIdentity _di = null;

	List _claimList = null;

	private void addToClaimList( Attribute attr ){
		try{
			RPClaimTypeImpl claimType = new RPClaimTypeImpl( attr.getNamespace() );
			claimType.setDisplayName( attr.getName() );

			RPClaimImpl claim = new RPClaimImpl( claimType );
			claim.addValue( attr.getValue() );

			_claimList.add( claim );

		} catch (URISyntaxException ex1){
			ex1.printStackTrace();
		}
	}


	public ICardRPToken( DigitalIdentity di){
		_di = di;
		_claimList = new ArrayList();
		Iterator attrs = _di.getIterator();
		while (attrs.hasNext()){
			addToClaimList((Attribute)attrs.next());
		}
	}

	public String getAsString() {

		return _di.getPpid();
	}

	public List getClaims() {

		return _claimList;
	}

	public URI getTokenType() {
		URI result = null;
		try{
			result =  new URI( "urn:oasis:names:tc:SAML:1.0:assertion");
		}
		catch(URISyntaxException exc1){
			exc1.printStackTrace();
		}
		return result;
	}
}


