/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.icard;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.AuthProtocolHandler;
import org.eclipse.higgins.rp.DispatchCallback;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.SessionContext;
import org.eclipse.higgins.rp.icard.ICardRPToken;
import org.eclipse.higgins.rp.icard.token.identity.DigitalIdentity;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtension;

public class ICardProtocolHandler
extends AuthProtocolHandler {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog((String)(class$org$eclipse$higgins$rp$icard$ICardProtocolHandler == null ? (class$org$eclipse$higgins$rp$icard$ICardProtocolHandler = ICardProtocolHandler.class$("org.eclipse.higgins.rp.icard.ICardProtocolHandler")) : class$org$eclipse$higgins$rp$icard$ICardProtocolHandler).getName());
    private static final int ERRORSTATE = 100;
    private static final int INITIALSTATE = 0;
    private static final int REDIRECTED = 1;
    private static final int AUTHENTICATED = 2;
    private static boolean init_errors = false;
    private static String _errorpage = null;
    private static final String TOKENPARAMETERNAME = "xmlToken";
    private ResultCallback _resultCallback = null;
    private DispatchCallback _dispatchCallback = null;
    private SessionContext _sessionContext = null;
    List _reqClaims = null;
    List _optClaims = null;
    List _reqClaimValues = null;
    List _optClaimValues = null;
    private int state = 0;
    private static String _loginFormLoc = null;
    private static KeyStore keyStore = null;
    private boolean keystoreInited = false;
    private static String keyStorePwd = null;
    private static String keyStoreAlias = null;
    private static String keyStoreName = null;
    private static String keyStoreType = null;
    private static Map ppidToDigitalIdentityMap = null;
    private static String _xmlSecConfigFile = "config.xml";
    private static final String LOGIN_PAGE_ATTRIBUTE = "icardLoginPage";
    private static final String XMLSEC_CONFIG_ATTRIBUTE = "xmlsecconfig";
    static /* synthetic */ Class class$org$eclipse$higgins$rp$icard$ICardProtocolHandler;
    static /* synthetic */ Class class$java$lang$String;

    public void registerCallbacks(ResultCallback resultCallback, DispatchCallback dispatchCallback, SessionContext ctxt) {
        this._resultCallback = resultCallback;
        this._dispatchCallback = dispatchCallback;
        this._sessionContext = ctxt;
    }

    public void authenticate(Map requestHeaders, Map requestParams) {
        if (init_errors) {
            this.state = 100;
        }
        switch (this.state) {
            case 0: {
                log.debug((Object)"Current state is INITIALSTATE");
                this._sessionContext.storeAttribute("ErrorPage", (Object)_errorpage);
                this._dispatchCallback.redirect(this.addAuthSessionToLocation(_loginFormLoc));
                this.state = 1;
                return;
            }
            case 1: {
                log.debug((Object)"Current state is REDIRECTED");
                this.processUserToken(requestParams);
                return;
            }
            case 2: 
            case 100: {
                log.debug((Object)"Current state is AUTHENTICATED or ERRORSTATE");
                this.state = 100;
                this._resultCallback.handleFailure(-3);
                return;
            }
        }
    }

    public void processUserToken(Map reqParams) {
        DigitalIdentity di = null;
        String strToken = null;
        String[] strTokenValues = (String[])reqParams.get(TOKENPARAMETERNAME);
        if (strTokenValues != null) {
            strToken = strTokenValues[0];
        }
        try {
            if (strToken != null) {
                Element elemToken = new Element();
                elemToken.set((Object)strToken);
                if (_xmlSecConfigFile != null) {
                    log.debug((Object)("Setting system property org.apache.xml.security.resource.config to " + _xmlSecConfigFile));
                    System.setProperty("org.apache.xml.security.resource.config", _xmlSecConfigFile);
                }
                XMLSecurityApacheExtension secext = new XMLSecurityApacheExtension();
                IElement ie = null;
                secext.configure(new HashMap(), null, new HashMap(), null, null);
                if (!this.keystoreInited) {
                    this.keystoreInited = true;
                    keyStore = ICardProtocolHandler.getKeyStore(keyStoreType, this._sessionContext.getRealPath(keyStoreName), keyStorePwd.toCharArray());
                }
                PrivateKey key = (PrivateKey)keyStore.getKey(keyStoreAlias, keyStorePwd.toCharArray());
                log.info((Object)("Decrypt token using key " + key + " key algorithm " + key.getAlgorithm()));
                ie = secext.DecryptElement((IElement)elemToken, (PrivateKey)keyStore.getKey(keyStoreAlias, keyStorePwd.toCharArray()));
                log.info((Object)("Decrypted token looks like\n" + ie.getAs(class$java$lang$String == null ? (class$java$lang$String = ICardProtocolHandler.class$("java.lang.String")) : class$java$lang$String)));
                secext.VerifyEnveloped(ie, (IConstants)new Constants());
                di = DigitalIdentity.fromXml(ie);
                log.info((Object)di);
                ppidToDigitalIdentityMap.put(di.getPpid(), di);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to proecess token");
            e.printStackTrace(new PrintStream(System.out));
        }
        if (di != null) {
            log.info((Object)"Sucessfully authenticated token");
            this._resultCallback.handleSuccess(this._sessionContext.getProtectedResource(), (RPSecurityToken)new ICardRPToken(di));
            this.state = 2;
        } else {
            log.info((Object)"Error authenticating token");
            this._resultCallback.handleFailure(-1);
            this.state = 100;
        }
    }

    public static String getSupportedTokenName() {
        return "urn:oasis:names:tc:SAML:1.0:assertion";
    }

    public void init(List requiredClaims, List optionalClaims) {
        this._reqClaims = requiredClaims;
        this._optClaims = optionalClaims;
    }

    public List getOptionalClaims() {
        return this._optClaims;
    }

    public List getRequiredClaims() {
        return this._reqClaims;
    }

    private static KeyStore getKeyStore(String type, String name, char[] pw) {
        KeyStore answer = null;
        try {
            if (type == null) {
                type = KeyStore.getDefaultType();
            }
            log.info((Object)("name: " + name + " type: " + type));
            answer = KeyStore.getInstance(type);
            answer.load(new FileInputStream(name), pw);
        }
        catch (KeyStoreException kse) {
            log.info((Object)"KeyStore Exception while loading keystore ");
            kse.printStackTrace();
            throw new RuntimeException();
        }
        catch (CertificateException ce) {
            log.info((Object)"Certificate Exception while loading keystore ");
            ce.printStackTrace();
            throw new RuntimeException();
        }
        catch (FileNotFoundException fnfe) {
            log.info((Object)("KeyStore File not found " + name));
            fnfe.printStackTrace();
            throw new RuntimeException();
        }
        catch (IOException ioe) {
            log.info((Object)(" IOException while reading file " + name));
            ioe.printStackTrace();
            throw new RuntimeException();
        }
        catch (NoSuchAlgorithmException nsae) {
            log.info((Object)"No such algorithm");
            nsae.printStackTrace();
            throw new RuntimeException();
        }
        return answer;
    }

    public static void init(Map initParams) {
        keyStoreName = (String)initParams.get("keystorename");
        String kspwd = (String)initParams.get("keystorepw");
        keyStoreType = (String)initParams.get("keystoretype");
        String ksalias = (String)initParams.get("keystorekeyalias");
        _errorpage = (String)initParams.get("icardErrorPage");
        log.info((Object)"initializing");
        if (keyStoreName == null || kspwd == null || ksalias == null) {
            init_errors = true;
            if (keyStoreName == null) {
                log.warn((Object)"keystorenamenot set");
            }
            if (kspwd == null) {
                log.warn((Object)"keystorepwnot set");
            }
            if (ksalias == null) {
                log.warn((Object)"keystorekeyaliasnot set");
            }
            log.error((Object)"returning error state");
            return;
        }
        if (keyStoreType == null) {
            log.warn((Object)"keystoretypenot set");
        }
        keyStoreAlias = ksalias;
        keyStorePwd = kspwd;
        ppidToDigitalIdentityMap = new HashMap();
        _loginFormLoc = (String)initParams.get(LOGIN_PAGE_ATTRIBUTE);
        _xmlSecConfigFile = (String)initParams.get(XMLSEC_CONFIG_ATTRIBUTE);
    }

    public void setOptionalClaims(List optionalClaims) {
        this._optClaims = optionalClaims;
    }

    public void setRequiredClaims(List requiredClaims) {
        this._reqClaims = requiredClaims;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

