/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.rp.DispatchCallback;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.SessionContext;

public abstract class AuthProtocolHandler
implements Serializable {
    public static final String AUTH_SESSION_PARAM = "authsession";
    private String _sessionId = null;

    public String getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    public abstract void registerCallbacks(ResultCallback var1, DispatchCallback var2, SessionContext var3);

    public abstract void authenticate(Map var1, Map var2);

    public abstract void setRequiredClaims(List var1);

    public abstract void setOptionalClaims(List var1);

    public static void init(Map initParams) {
    }

    public static String getSupportedTokenName() {
        return null;
    }

    public abstract List getRequiredClaims();

    public abstract List getOptionalClaims();

    public String addAuthSessionToLocation(String location) {
        String result = null;
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException exc1) {
            result = location;
        }
        String queryStr = uri.getQuery();
        if (queryStr == null) {
            result = location + "?" + AUTH_SESSION_PARAM + "=" + this.getSessionId();
        } else if (queryStr.indexOf(AUTH_SESSION_PARAM) == -1) {
            result = location + "&" + AUTH_SESSION_PARAM + "=" + this.getSessionId();
        }
        return result;
    }
}

