/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.tokens;

import java.util.List;



/**
 * 
 * Interface describing a token returned by an authentication handler
 *
 */
public interface RPSecurityToken {

    /**
     * @return The serialized value of the token. Could be used to display the
     *         value of the token
     */
    String getAsString();

    /**
     * @return The claims that were attached to the token
     */
    List getClaims();

    /**
     * @return The canonical name for the token
     */
    java.net.URI getTokenType();
}
