/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp;

/**
 *  
 * This is the abstraction of the RequestDispatcher from J2EE Servlets
 *
 */
public interface DispatchCallback {
	
	/**
	 * Method to forward the handling of the request to the
	 * new local targetLocation
	 * 
	 * @param targetLocation Local location to dispatch request to
	 * 
	 */
	public void forward ( String targetLocation );
	
	
	/**
	 * Method to redirect user to an external location. This could implement the above also 
	 * but non-optimally
	 * 
	 * @param externalLocation external location of redirect
	 */
	
	public void redirect( String externalLocation );
}
