/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp;

import org.eclipse.higgins.rp.tokens.RPSecurityToken;


public interface ResultCallback {

    /**
     * Failure of the authentication process
     */
    final int RP_AUTHENTICATION_FAILURE = -1;

    /**
     * Timeout condition in the authentication protocol state machine
     */
    final int RP_AUTHENTICATION_TIMEOUT = -2;

    /**
     * Error condition in the authentication protocol state machine
     */
    final int RP_AUTHENTICATION_INTERNAL_ERROR = -3;
    
    

    /**
     * Callback for authentication process failure. 
     *  
     * @param errCode indication of what the reason for error was.
     * 
     */
    
    void handleFailure(int errCode);
    
    /**
     * Callback for authentication process failure. Also includes the root casue of error 
     *  
     * @param errCode indication of what the reason for error was.
     * 
     * @param rootCause of error 
     * 
     */
    
    void handleFailure (int errorCode, Throwable rootCause);

    /**
     * Callback on success of authentication process
     * 
     * @param authSession the authentication session
     * 
     * @param protectedResource is the resource trigerring authentication
     * 
     * @param authenticationResult is a token which contains the result of authentication
     * {@link org.eclipse.higgins.rp.tokens.RPSecurityToken}
     */
    void handleSuccess( String protectedResource, RPSecurityToken authenticationResult);

}
