/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 

package org.eclipse.higgins.rp;

/**
 * 
 * An interface by which protocol handlers can get access to the session context
 * 
 * 
 * This is the abstraction of the httpSession and portions of the
 * servletContext in J2EE containers
 * 
 *  Note: All the store/retrieve methods have two versions. One version
 *  is a Global attribute store and retrieve while the other stores
 *  and retrieves attribute/values in a specific context
 * 
 */

public interface SessionContext {

	
    /**
     * Associates a value with a key in the session store.
     * 
     * @param attribute String to specify name
     * @param value associated to this attribute
     * 
     * @return 0 on success.
     */
    int storeAttribute(String attribute, Object value);

    /**
     * Retrieves attribute associated with a given name
     * 
     * @param attribute key for retrieval. 
     * 
     * @return
     */
    Object retrieveAttribute(String attribute);

    /**
     * Check if there is a value attached to a given attribute.
     * 
     * @param attribute key to check for
     * 
     * @return true if there is a value attached to this key
     */
    boolean attributeExists(String attribute);

    /**
     * Deletes the value associated with an attribute if it exists.
     * 
     * @param attribute
     */
    void deleteAttribute(String attribute);

    /**
     * Associates a value with a key in the session store of a particular
     * authentication session. 
     * 
     * @param authSession name of the authentication session
     * @param attribute String to specify name
     * @param value associated to this attribute
     * 
     * @return 0 on success.
     */
    int storeAttribute(String authSession, String attribute, Object value);

    /**
     * Retrieves attribute associated with a given name in the
     * given authentication session
     * 
     * @param authSession name of the authentication session
     * @param attribute key for retrieval. 
     * 
     * @return
     */
    Object retrieveAttribute(String authSession, String attribute);

    /**
     * Check if there is a value attached to a given attribute in
     * the indicated authentication session.
     * 
     * @param authSession name of the authentication session
     * @param attribute key to check for
     * 
     * @return true if there is a value attached to this key
     */
    boolean attributeExists(String authSession, String attribute);

    /**
     * Deletes the value associated with an attribute if it exists.
     * 
     * @param authSession name of the authentication session
     * @param attribute
     */
    void deleteAttribute( String authSession, String attribute);
    
    
    /**
     * 
     * @return This returns the URI of the resource which triggered the
     *         authentication process.
     * 
     */
    String getProtectedResource();
    
    /**
     * @param rsrc the protected resource which triggered this authentication request
     */
    String setProtectedResource( String rsrc );

    /**
     * 
     * @return This returns the URI of the current request. This may be
     *         different from the URI which triggered the authentication
     * 
     */
    String getCurrentRequestUrl();
    
    /**
     * @param path is the virtual path
     * 
     * @return   Returns a String containing the real path for a given virtual path.
     */
    String getRealPath( String path );
}
