/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.server;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.servlet.server.Invoker;
import org.eclipse.higgins.sts.base64.apache.Base64ApacheExtension;

public class AuthNFilter
implements Filter {
    protected static Log log;
    private static final int BYTE_ARRAY_SIZE = 15;
    private static final SecureRandom SECURE_RANDOM;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.rp.servlet.server.AuthNFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        SECURE_RANDOM = new SecureRandom();
    }

    public static final String getNextAuthSession() {
        byte[] genBytes = new byte[15];
        String randomID = null;
        SECURE_RANDOM.nextBytes(genBytes);
        try {
            randomID = new Base64ApacheExtension().encode(genBytes).replace('+', 'P');
        }
        catch (Exception exception) {
            throw new RuntimeException(" Base64 encoding error ");
        }
        return randomID;
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        HttpSession httpsession = req.getSession();
        boolean runFilter = true;
        boolean concurrentRequest = false;
        String authSession = null;
        log.info((Object)(String.valueOf(req.getRemoteHost()) + " tried to access " + req.getRequestURL() + " on " + new Date()));
        String token_id = (String)httpsession.getAttribute("ReturnedTokenId");
        authSession = req.getParameter("authsession");
        if (token_id == null) {
            runFilter = false;
        } else {
            log.info((Object)"User is already authenticated");
            if (authSession != null) {
                runFilter = false;
                concurrentRequest = true;
            }
        }
        if (runFilter) {
            fChain.doFilter(request, response);
        } else if (concurrentRequest) {
            AuthNFilter.handleConcurrentRequest(authSession, req, resp);
        } else {
            HashMap<String, String> _mp = null;
            if (authSession == null) {
                authSession = AuthNFilter.getNextAuthSession();
                _mp = new HashMap<String, String>();
                _mp.put("protectedresource", String.valueOf(req.getRequestURL().toString()) + (req.getQueryString() == null ? "" : "?" + req.getQueryString()));
                _mp.put("_authenticationState", "Initializing");
                httpsession.setAttribute(authSession, _mp);
            } else {
                _mp = (HashMap<String, String>)httpsession.getAttribute(authSession);
                _mp.put("_authenticationState", "Processing");
            }
            _mp.put("request", (String)req);
            _mp.put("response", (String)resp);
            Invoker.invoke(authSession, httpsession);
        }
    }

    public static void handleConcurrentRequest(String authSession, HttpServletRequest req, HttpServletResponse resp) {
        HttpSession httpsession = req.getSession();
        Map _mp = (Map)httpsession.getAttribute(authSession);
        if (_mp != null) {
            String redirect = (String)_mp.get("protectedresource");
            httpsession.removeAttribute(authSession);
            try {
                resp.sendRedirect(redirect);
            }
            catch (IOException iOException) {
                throw new RuntimeException(" Unable to redirect user to " + redirect);
            }
        } else {
            return;
        }
    }
}

