/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Paula Austel, Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 

package org.eclipse.higgins.rp.servlet.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.DispatchCallback;
import org.eclipse.higgins.rp.servlet.server.CxtConstants;

public class DispatchCallbackHandler implements DispatchCallback,Serializable {

	private static final long serialVersionUID = 1L;
	private String _authContext = null;
	private HttpSession _httpsession = null;
	private Map _mp = null;
	protected static Log log =
        LogFactory.getLog(DispatchCallbackHandler.class.getName());
	
	public DispatchCallbackHandler(String authContext, HttpSession httpsession ){
		_authContext = authContext;
		_httpsession = httpsession;
		_mp = (Map)_httpsession.getAttribute( _authContext );
	}

	public void redirect(String externalLocation) {
		
		HttpServletResponse response = (HttpServletResponse)_mp.get(CxtConstants.RESPONSE);
		log.debug(_httpsession.getId());
		log.info(externalLocation);
		try {
			response.sendRedirect(externalLocation);
		} catch (IOException exc) {
			exc.printStackTrace();
		}
	}

	public void forward(String targetLocation) {
		HttpServletRequest request = (HttpServletRequest)_mp.get(CxtConstants.REQUEST);
		HttpServletResponse response = (HttpServletResponse)_mp.get(CxtConstants.RESPONSE);
		RequestDispatcher rd = request.getRequestDispatcher(targetLocation);
		log.debug(_httpsession.getId());
		log.info(targetLocation);
		try {
			rd.forward(request, response);
		} catch (ServletException exc1) {
			exc1.printStackTrace();
		} catch (IOException exc2) {
			exc2.printStackTrace();
		}
	}
     
}
