/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Paula Austel (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.servlet.server;

import java.io.IOException;
import java.util.Date;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * Login filter
 * The login filter is specified in the web.xml file for the application and must be defined as
 * a filter for the login jsp file that is defined in the properties file for the protocol handler.
 * On GET the filter will get the context params set them as attributes to the request for the
 * login jsp. 
 * On POST the filter calls the authenticate method of the protocol handler to continue processing
 * the authentication. The authentication method of the protocol handler keeps track of authentication
 * state and knows when to transition between states. 
 *
 */
public class LoginFilter implements Filter {
	private String filterName; // according to web.xml
	protected static Log log =
        LogFactory.getLog(LoginFilter.class.getName());
	
	public void destroy() {
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain fChain) throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest)request;
		HttpServletResponse resp = (HttpServletResponse)response;
		log.info(req.getRemoteHost() +
				" tried to access " +
				req.getRequestURL() +
				" on " + new Date() + ". " +
				"(Reported by " +
				filterName + ".)");
		
		if ( req.getMethod().equals("POST" )){		
			Login.ContinueAuthentication(req, resp);
		} 
		else 
			fChain.doFilter(request, response);					
	}

	public void init(FilterConfig fConfig) throws ServletException {
		// remember the context, won't get another peek at it if we don't remember it now
		filterName = fConfig.getServletContext().getServletContextName();
	}
	
}
